# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS

from scenes.base_scene import BaseScene
from kiki.util.log import file_logger as logger
from res.res_path import RES_PATH


import time
from res.swkbd.chara_pos_dictionary import *

_ICON_IMAGE_PATH = RES_PATH + "/swkbd/"

class Swkbd(BaseScene):
    def __init__(self, driver):
        super(Swkbd, self).__init__(driver)
        self.cur_keyboard_mode = 0
        self.cur_keyboard_type = KeyBoardType.unknown
        self.cur_inputmode = CharacterType.unknown

    def is_available(self):
       return True

    def _search_icon_from_image_list(self, icon_image_list, threshold=0.8, shows_result=False):
        """ 画像のリストのうち、一つでもヒットしたらその場所を返す

        :param icon_image_list:
        :param shows_result:
        :return:
        """
        for icon_image in icon_image_list:
            result = self.driver.screen.detect_object_with_image(icon_image, threshold=threshold, shows_result=shows_result)
            if result is not None:
                logger.debug(u"[search_icon_from_image_list]アイコン発見")
                return result[0], result[1]

    def search_keyboardtype_icon(self, icon_image_list, threshold, shows_result):
        # キーボードアイコン探して入る
        logger.info("Searching the keyboard[キーボードアイコンを探しています]...")
        for i in range(20):
            result_pos = self._search_icon_from_image_list(icon_image_list, threshold, shows_result)
            if result_pos is not None:
                print(result_pos)
                # キーボード変更直後に意図しない文字が入力されていた対応(きぐち)
                self.driver.screen.touch(0,x= result_pos[0]+20,y= result_pos[1]+20, ms_after=1000)
                return True
            else:
                self.driver.controllers[0].push("DOWN", ms_after=250)

        logger.warning("Could not detect the keyboard[キーボードアイコンを探しています]...")
        return False

    def get_cur_keyboard_mode(self,logstore):
        #ログにより起動時のSWKBDのキーボードモードを判定する
        """
        numeric_kbd_image_list = [_ICON_IMAGE_PATH + "ss_numeric_keyboad_1.PNG"]
        result_pos = self._search_icon_from_image_list(numeric_kbd_image_list, threshold=0.85, shows_result=False)
        if result_pos is not None :
            self.cur_keyboard_mode = KeyboardMode.Numeric

        else:
            self.driver.screen.touch(0, x=100, y=620, ms_after=500)
            time.sleep(2)
            ascii_kbd_image_list = [_ICON_IMAGE_PATH + "ss_keyboard_qwerty.PNG"]
            result_pos = self._search_icon_from_image_list(ascii_kbd_image_list, threshold=0.85, shows_result=False)
            if result_pos is not None :
                self.cur_keyboard_mode = KeyboardMode.Ascii
                self.driver.screen.touch(0, x=100, y=685, ms_after=500)
            else:
                self.cur_keyboard_mode = KeyboardMode.Full
                self.driver.screen.touch(0, x=100, y=685, ms_after=500)
            """
        time.sleep(2)
        logstore.move_pointer_newest()
        logger.info("Start read_line_until")
        match = logstore.read_line_until(reg_str="\<swkbd\>.*KeyboardMode\:.*", ms_timeout=20000,is_reverse=True)
        if match is not None:
            # 20170110 KeyboardMode:3 ( = FullLatin )の時は Full モードとほぼ同等なので 0 を返す
            k_mode_index = match.string.split(":")[3]
            if k_mode_index == "3":
                k_mode_index = "0"
            return k_mode_index
        else:
            print("matching timeout")
            logger.error(u"get_cur_keyboard_mode None 防止のため文字列の0を返します。")
            return "0"


    def swkbd_input_character_of_str(self, str,dict):
        # SWKBD上でstrで受け取った文字列を1文字ずつ入力する
        # chara_pos = {n:[x_pos,y_pos,入力モード,大文字フラグ,小字゛゜フラグ]}
        chara_pos = dict

        keyboard_type_image = {
            KeyBoardType.English_US:[_ICON_IMAGE_PATH + "ss_keyboard_english_us.PNG",
                                     _ICON_IMAGE_PATH + "ss_keyboard_english_us_active.PNG",
                                     _ICON_IMAGE_PATH + "ss_keyboard_english_uk.PNG",
                                     _ICON_IMAGE_PATH + "ss_keyboard_english_uk_active.PNG",],
            KeyBoardType.Quebecois:[],
            KeyBoardType.Espanol_latino:[],
            KeyBoardType.EnglishUK:[],
            KeyBoardType.Francais:[],
            KeyBoardType.Deutsch:[],
            KeyBoardType.Italiano_QWERTY:[],
            KeyBoardType.Italiano_QZERTY:[],
            KeyBoardType.Espanol:[],
            KeyBoardType.Nederlands:[],
            KeyBoardType.Portugues:[],
            KeyBoardType.Russian:[],
            KeyBoardType.Russian_Latin_character:[],
            KeyBoardType.Japanese_row:[_ICON_IMAGE_PATH + "ss_keyboard_jp_row.PNG",
                                      _ICON_IMAGE_PATH + "ss_keyboard_jp_row_active.PNG" ],
            KeyBoardType.Japanese_left_starting:[],
            KeyBoardType.Japanese_right_starting:[_ICON_IMAGE_PATH + "ss_keyboard_jp_right.PNG",
                                                  _ICON_IMAGE_PATH + "ss_keyboard_jp_right_active.PNG"],
            KeyBoardType.Signs:[_ICON_IMAGE_PATH + "ss_keyboard_signs_jp.PNG",
                                _ICON_IMAGE_PATH + "ss_keyboard_signs_jp_active.PNG",
                                _ICON_IMAGE_PATH + "ss_keyboard_symbol_us.PNG",
                                _ICON_IMAGE_PATH + "ss_keyboard_symbol_us_active.PNG",],
            KeyBoardType.QWERTY:[_ICON_IMAGE_PATH + "ss_qwerty_keyboard_active.png",
                                 _ICON_IMAGE_PATH + "ss_qwerty_keyboard.png"],
            KeyBoardType.AZERTY:[],
            KeyBoardType.QWERTZ:[],
            KeyBoardType.QZERTY:[],
            KeyBoardType.Add_new_keyboard:[]
        }

        inputmode_pos = {
            CharacterType.HIRAGANA :[80,360],
            CharacterType.KATAKANA :[125,360],
            CharacterType.JpAlphabetSmall :[80,425],
            CharacterType.JpAlphabetLarge :[125,425],
            CharacterType.JpSigns : [105,485],
            CharacterType.Alphabet :[10,710],
            CharacterType.Signs0 :[105,360],
            CharacterType.Signs1 :[105,425],
            CharacterType.Signs2 :[105,490],
            CharacterType.Signs3 :[105,555],
            CharacterType.AsciiAlphabet : [10,710],
            CharacterType.AsciiSigns : [300,615],
            CharacterType.NumericNums : [10,710]
        }

        # input_pos = {入力モード:[x_pos,y_pos,キーボード選択時のアイコン]}
        for chara in str: #入力したい文字列をstrで受け取り1文字ずつタッチ入力

            # 受け取った文字の入力モードと現在の入力モードを比較し、適切なキーボードと入力モードに遷移する
            if chara_pos[chara][5] is not self.cur_keyboard_type:
                self.cur_keyboard_type = chara_pos[chara][5]
                if self.cur_inputmode is not CharacterType.NumericNums:
                    self.driver.screen.touch(0, x=100, y=620, ms_after=1500) # keyboard切り替えアイコンをタッチ

                    # キーボード一覧でカーソルを最上段へ。
                    self.driver.controllers[0].push("UP", ms_press=3000, ms_after=500)

                    keyboard_image = keyboard_type_image[self.cur_keyboard_type]
                    self.search_keyboardtype_icon(icon_image_list=keyboard_image,threshold=0.87,shows_result=False)

            if chara_pos[chara][2] is not  self.cur_inputmode:
                self.cur_inputmode = chara_pos[chara][2]
                if not self.cur_inputmode is CharacterType.Alphabet:
                    self.driver.screen.touch(0, x= inputmode_pos[self.cur_inputmode][0], y= inputmode_pos[self.cur_inputmode][1], ms_after=500)

            # shift 必要な文字なら shift をタッチ
            if chara_pos[chara][3] is True:
                self.driver.screen.touch(0, x=200, y=610, ms_after=500)

            # screen 上の chara_pos をタッチ
            self.driver.screen.touch(0, x=chara_pos[chara][0], y=chara_pos[chara][1], ms_after=300)

            # 小文字濁点半濁点文字なら小字゛゜タッチ
            for x in range(chara_pos[chara][4]):
                self.driver.screen.touch(0, x=105, y=555, ms_after=500)

    def swkbd_initialize_imputmode(self):
        self.cur_inputmode = CharacterType.unknown
        self.cur_keyboard_type = KeyBoardType.unknown

    def swkbd_input_enter(self):
        if self.cur_keyboard_mode == "1":
            self.driver.screen.touch(0,x=985, y=545, ms_after=500)
            #self.driver.screen.touch(0,x=985, y=545, ms_after=500)
        else:
            self.driver.screen.touch(0,x=1130, y=615, ms_after=500)
            #self.driver.screen.touch(0,x=1130, y=615, ms_after=500)

    def swkbd_input_str_with_verify(self,str):
        # ログをとりつつ str で渡された文字列を入力し、TMログの比較を行う
        self.driver.log_reader.open()
        self.swkbd_input_str(str)
        self.swkbd_input_enter()
        self.swkbd_verify_with_read_logs(str)
        self.driver.log_reader.close()

    def swkbd_verify_with_read_logs(self,input_str):
        # input_str で渡された文字列とTMログの比較を行う（入力前に外でlog_readerを開いて使う必要がある）
        # 抽出するログの対象がapplet_caller になっているので、今後ログが変わる可能性がある！
        logger.info("Start read_line_until")
        match = self.driver.log_reader.read_line_until(reg_str="\<applet_caller>" and "result : (.*)", ms_timeout=10000)
        if match is not None:
            print("seaching:"+ input_str)
            print("detected:"+ match.group(1))
            if match.group(1) == input_str :
                print("input_strings_verify_OK")
                logger.info("入力文字とTargetManager に表示された入力ログの内容が一致しました")

            else:
                print("input_strings_verify_NG")
                logger.info("入力文字とTargetManager に表示された入力ログの内容が一致しません")

        else:
            print("matching timeout")
            logger.info("読み込んだログから文字列入力のログが見つかりませんでした")


    def swkbd_input_str(self,str,language,logstore):
        # language は文字列で渡してください
        #キーボードモード（full,ascii.numeric) を判定する
        self.cur_keyboard_mode = self.get_cur_keyboard_mode(logstore)

        #判定したモードから、入力のための座標情報を保存した辞書を呼び出して文字入力の関数に渡す
        keyboard_mode_dict = {
            "2" : ascii_chara_pos,
            "1" : numeric_chara_pos
            }

        lang_full_chara_pos = {
            "jp" : full_chara_pos_jp,
            "us_en" : full_chara_pos_us_en,
            "eu_en" : full_chara_pos_eu_en,
            "us_fr" : full_chara_pos_us_fr,
            "eu_fr" : full_chara_pos_eu_fr,
            "us_esp" : full_chara_pos_us_esp,
            "eu_esp" : full_chara_pos_eu_esp,
            "eu_ger" : full_chara_pos_eu_ger,
            "eu_ner" : full_chara_pos_eu_ner,
            "eu_por" : full_chara_pos_eu_por,
            "ru" : full_chara_pos_ru,
        }

        if self.cur_keyboard_mode == "0":
            self.swkbd_input_character_of_str(str,dict=lang_full_chara_pos[language])

        else :
            # print(keyboard_mode_dict, self.cur_keyboard_mode)
            self.swkbd_input_character_of_str(str,dict=keyboard_mode_dict[self.cur_keyboard_mode])


