# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS

from scenes.base_scene import BaseScene
from kiki.util.log import file_logger as logger
from res.res_path import RES_PATH


import time
from res.swkbd.chara_pos_dictionary import *

_ICON_IMAGE_PATH = RES_PATH + "/quick_setting/"


class QuickSetting(BaseScene):
    def __init__(self, driver):
        super(QuickSetting, self).__init__(driver)


    def is_available(self):
        return True

    def is_available_from_log(self,logstore):
        #直前のログを確認してクイック設定に来てるかを判定する
        logger.info("Start read_line_until")
        match = logstore.read_line_until(reg_str="\<overlayDisp\>.*\[ducking\] enter MiniSet.*"
                                         , ms_timeout=10000)
        if match is not None:
            print(match.string)
            return True
        else:
            print("matching timeout")
            return False

    def has_been_closed(self,logstore):
        #直前のログを確認してクイック設定#が閉じたかを判定する
        logger.info("Start read_line_until")
        match = logstore.read_line_until(reg_str="\<overlayDisp\>.*\[ducking\] exit MiniSet.*"
                                         , ms_timeout=10000)
        if match is not None:
            print(match.string)
            return True
        else:
            print("matching timeout")
            return False

    def search_icon(self, name, threshold=0.8, shows_result=False):
        if type(name) == list:
            for image_name in name:
                icon_image = _ICON_IMAGE_PATH + image_name
                icon = icon_image
                result = self.driver.screen.detect_object_with_image(icon, threshold=threshold, shows_result=shows_result)
                if result is not None:
                    return result[0], result[1]
            return None
        else:
            icon_image = _ICON_IMAGE_PATH + name
            icon = icon_image
            result = self.driver.screen.detect_object_with_image(icon, threshold=threshold, shows_result=shows_result)
            if result is not None:
                return result[0], result[1]
            else:
                return None

    def _search_icon_from_image_list(self, icon_image_list, threshold=0.8, shows_result=False):
        """ 画像のリストのうち、一つでもヒットしたらその場所を返す

        :param icon_image_list:
        :param shows_result:
        :return:
        """
        for icon_image in icon_image_list:
            result = self.driver.screen.detect_object_with_image(icon_image, threshold=threshold, shows_result=shows_result)
            if result is not None:
                logger.debug(u"[search_icon_from_image_list]アイコン発見")
                return result[0], result[1]

    def switch_flight_mode(self):
        self.driver.screen.touch(0, 1200, 560, ms_after=1000)
        icon_image =  _ICON_IMAGE_PATH + "ss_quick_setting_flight_on.PNG"
        result = self.driver.screen.detect_object_with_image(icon_image, threshold=0.8, shows_result=False)
        if result is not None:
            logger.debug(u"タッチ操作で機内モードをONからOFFに切り替えます")
        else:
            logger.debug(u"タッチ操作で機内モードをOFFからONに切り替えます")

