# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS

from scenes.base_scene import BaseScene
from kiki.util.log import file_logger as logger
from res.res_path import RES_PATH

import time

_ICON_IMAGE_PATH = RES_PATH + "/auth/"

class Auth(BaseScene):
    def __init__(self, driver):
        super(Auth, self).__init__(driver)
        self.logstore = self.driver.log_reader.create_logstore()


    def is_available(self):
        pass

    def is_available_from_log(self):
        time.sleep(2)
        logger.info("Start read_line_until")
        self.logstore.move_pointer_newest()
        match = self.logstore.read_line_until(reg_str="\<auth\>.*\[GuiPasscode.*setEnterableKeyInput\] is_enterable.*1"
                                         , ms_timeout=10000,is_reverse=True)
        if match is not None:
            print(match.string)
            logger.debug("authキーボードにいます")
            return True
        else:
            print("matching timeout")
            logger.debug("authキーボードにいません")
            return False

    def _search_icon_from_image_list(self, icon_image_list, threshold=0.8, shows_result=False):
        """ 画像のリストのうち、一つでもヒットしたらその場所を返す

        :param icon_image_list:
        :param shows_result:
        :return:
        """
        for icon_image in icon_image_list:
            result = self.driver.screen.detect_object_with_image(icon_image, threshold=threshold, shows_result=shows_result)
            if result is not None:
                logger.debug(u"[search_icon_from_image_list]アイコン発見")
                return result[0], result[1]

    def auth_swkbd_input_str(self, str):
        # SWKBD上でstrで受け取った文字列を1文字ずつ入力する
        # chara_pos = {n:[x_pos,y_pos,入力モード,大文字フラグ,小字゛゜フラグ]}
        chara_pos = {
            "1":[455,415],
            "2":[640,415],
            "3":[825,415],
            "4":[455,480],
            "5":[640,480],
            "6":[825,480],
            "7":[455,545],
            "8":[640,545],
            "9":[825,545],
            "*":[455,610],
            "0":[640,610],
            "#":[825,610],
        }
        # input_pos = {入力モード:[x_pos,y_pos,キーボード選択時のアイコン]}
        for chara in str: #入力したい文字列をstrで受け取り1文字ずつタッチ入力
            # screen 上の chara_pos をタッチ
            self.driver.screen.touch(0, x=chara_pos[chara][0], y=chara_pos[chara][1], ms_after=300)

    def auth_swkbd_input_enter(self):
        self.driver.screen.touch(0,x=980, y=550, ms_after=500)




