# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS
from scenes.base_scene import BaseScene
from scenes.common.swkbd import Swkbd
from scenes.setting_mii.mii_edit import MiiEdit

from kiki.util.log import file_logger as logger
from res.res_path import RES_PATH
from testcases.examples.utility import touch_nth_icon_from_matrix


_ICON_IMAGE_PATH = RES_PATH + "/cabinet/"

class Cabinet(BaseScene):
    def __init__(self, driver):
        super(Cabinet, self).__init__(driver)
        self.swkbd = Swkbd(driver)
        self.miiedit = MiiEdit(driver)

    def is_available(self):
        icon_image_list = [
                           _ICON_IMAGE_PATH + "ss_cabinet_nickname_and_owner_jp.PNG",
                           _ICON_IMAGE_PATH + "ss_cabinet_delete_game_data_jp.PNG",
                           _ICON_IMAGE_PATH + "ss_cabinet_initialize_jp.PNG",
                           #_ICON_IMAGE_PATH + "ss_news_list_title_us_en.PNG",
                           #_ICON_IMAGE_PATH + "ss_news_list_title_us_en.PNG",
                           #_ICON_IMAGE_PATH + "ss_news_list_title_us_en.PNG",
                            ]

        for icon_image in icon_image_list:
            if self.driver.screen.detect_object_with_image(icon_image) is not None:
                return True

            else:
                return False

    def is_available_from_log(self,logstore):
        #直前のログを確認してcabinetにいるかを判定する
        logger.info("Start read_line_until")
        match = logstore.read_line_until(reg_str="\<cabinet\>.*waiting detect.*"
                                         , ms_timeout=10000)
        if match is not None:
            print(match.string)
            return True
        else:
            print("matching timeout")
            return False

    def _search_icon_from_image_list(self, icon_image_list, threshold=0.8, shows_result=False):
        """ 画像のリストのうち、一つでもヒットしたらその場所を返す

        :param icon_image_list:
        :param shows_result:
        :return:
        """
        for icon_image in icon_image_list:
            result = self.driver.screen.detect_object_with_image(icon_image, threshold=threshold, shows_result=shows_result)
            if result is not None:
                logger.debug(u"[search_icon_from_image_list]アイコン発見")
                return result[0], result[1]

    def select_nth_mii_as_owner(self,n):
        ### n番目のMiiをオーナー登録する ### Miiがなければ新しく作る＋指定なければ0番目のMiiを選ぶ
        self.driver.screen.touch(0, x=935, y=265, ms_after=200)
        icon_image = _ICON_IMAGE_PATH + "ss_cabinet_move_to_mii_edit_jp.PNG"
        result = self.driver.screen.detect_object_with_image(icon_image, threshold=0.7, shows_result=False)
        if result is not None: #でっかいMiiを作るアイコンを見つけたらMiiなしと判断してMiiを作りに行く
                logger.debug(u"Miiが1体もいません")
                self.driver.screen.touch(0, x=635, y=450, ms_after=200)
                mii_edit_image =  _ICON_IMAGE_PATH + "ss_mii_edit_anchor.PNG"
                self.driver.screen.wait_until_detect_object(mii_edit_image,threshold=0.7)
                self.driver.screen.touch(0, x=375, y=275, ms_after=500)
                self.driver.screen.touch(0, x=520, y=350, ms_after=500)
                self.driver.screen.touch(0, x=215, y=210, ms_after=500)
                self.miiedit.set_nickname(nickname="auto",language="jp")
                self.miiedit.establish_a_mii()

        touch_nth_icon_from_matrix(self.driver,number=n,x_org=260,y_org=315,row_num= 5,cal_num=2,
                                   x_apart=190,y_apart=275)

    def input_nickname_amiibo(self,nickname_amiibo,language):
        self.driver.screen.touch(0, x=935, y=380, ms_after=200)
        self.swkbd.swkbd_input_str(nickname_amiibo,language)
        self.swkbd.swkbd_input_enter()

    def start_writing_amiibo(self):
        self.driver.screen.touch(0, x=635, y=510, ms_after=200) # [register]部分をタッチ
        icon_image = _ICON_IMAGE_PATH + "ss_cabinet_amiibo_finished_written.PNG"
        self.driver.screen.wait_until_detect_object(icon_image,threshold=0.7) # 書き込み完了まで待つ


    def wait_finish_reading_amiibo(self):
        pass


    def write_owner_and_nickname_with_verify(self):
        #オーナーMiiの画像をgetroiして再読み込み時にそれをdetectさせる
        pass

    def delete_game_data_with_verify(self):
        pass

    def initialize_data_with_verify(self):
        pass





