# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals
import os

from kiki.util.log import kiki_logger as logger

RES_PATH = os.path.dirname(__file__)


def reflect_config():
    """
        別のモジュールから読み込まれる前に呼ばれないと意味がない。
        でも循環参照をしないために呼び出しをconfig側で行っている

    :return: None
    """

    from examples.config.confmgr import CONF

    global RES_PATH
    if CONF.RES_PATH == RES_PATH:
        return

    old = RES_PATH
    RES_PATH = CONF.RES_PATH

    logger.info("Config value was reflected.")
    logger.info(old)
    logger.info("↓")
    logger.info(RES_PATH)
