﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include "TestUtil.h"

using namespace hidInputer;

TEST( HidInputerSuite, AnalogStickControlTest )
{
    // ターゲットシリアル取得
    SerialNumberString serialNumber;
    ASSERT_TRUE(GetTargetSerial(&serialNumber));

    // Hid ライブラリのラッパークラス
    HidInputerWrapper       hidInputerWrapper;

    // ライブラリ読み込みテスト
    ASSERT_TRUE(hidInputerWrapper.LoadHidLibrary());

    // 関数読み込みテスト
    ASSERT_TRUE(hidInputerWrapper.LoadFunctiontions());
    hidInputerWrapper.m_InitializeFunction(serialNumber);

    //-------------------------------------
    // 事前にすべてのコントローラーを接続しておく
    //-------------------------------------
    ConnectAllController(&hidInputerWrapper );

    //-------------------------------------
    // 接続済みの全コントローラーのアナログスティックを操作
    //-------------------------------------
    for (int i = 0; i < g_AllControllerIndexRange; i++)
    {
        float degree    = CreateDegree(false);
        float power     = CreatePower(false);
        Stick invalidStick = static_cast<Stick>(CreateInvalidStick());

        //-------------------------------------
        // 正常なスティックに対して操作
        //-------------------------------------
        // 傾ける
        EXPECT_EQ(hidInputerWrapper.m_HoldAnalogStickFunction(i, Stick::Stick_L, degree, power), ControllerResult::ControllerResult_Success);
        EXPECT_EQ(hidInputerWrapper.m_HoldAnalogStickFunction(i, Stick::Stick_R, degree, power), ControllerResult::ControllerResult_Success);

        // 傾きを解除
        EXPECT_EQ(hidInputerWrapper.m_ReleaseAnalogStickFunction(i, Stick::Stick_L), ControllerResult::ControllerResult_Success);
        EXPECT_EQ(hidInputerWrapper.m_ReleaseAnalogStickFunction(i, Stick::Stick_R), ControllerResult::ControllerResult_Success);

        // 傾けて元に戻す
        EXPECT_EQ(hidInputerWrapper.m_TiltAnalogStickFunction(i, Stick::Stick_L, degree, power, g_DefaultWaitPress), ControllerResult::ControllerResult_Success);
        EXPECT_EQ(hidInputerWrapper.m_TiltAnalogStickFunction(i, Stick::Stick_R, degree, power, g_DefaultWaitPress), ControllerResult::ControllerResult_Success);

        //-------------------------------------
        // 不正なスティックに対して操作
        //-------------------------------------
        EXPECT_EQ(hidInputerWrapper.m_HoldAnalogStickFunction(i, invalidStick, degree, power), ControllerResult::ControllerResult_InvalidStick);
        EXPECT_EQ(hidInputerWrapper.m_ReleaseAnalogStickFunction(i, invalidStick), ControllerResult::ControllerResult_InvalidStick);
        EXPECT_EQ(hidInputerWrapper.m_TiltAnalogStickFunction(i, invalidStick, degree, power, g_DefaultWaitPress), ControllerResult::ControllerResult_InvalidStick);
    }

    for (int i = 0; i < g_DefaultTryTimes; i++)
    {
        int id = CreateInvalidControllerId();
        float degree = CreateDegree( false );
        float power = CreatePower(false);

        //-------------------------------------
        // 不正なコントローラー ID に対して操作
        //-------------------------------------
        // 傾ける
        EXPECT_EQ(hidInputerWrapper.m_HoldAnalogStickFunction(id, Stick::Stick_L, degree, power), ControllerResult::ControllerResult_InvalidControllerId);

        EXPECT_EQ(hidInputerWrapper.m_HoldAnalogStickFunction(id, Stick::Stick_R, degree, power), ControllerResult::ControllerResult_InvalidControllerId);

        // 傾きを解除
        EXPECT_EQ(hidInputerWrapper.m_ReleaseAnalogStickFunction(id, Stick::Stick_L), ControllerResult::ControllerResult_InvalidControllerId);

        EXPECT_EQ(hidInputerWrapper.m_ReleaseAnalogStickFunction(id, Stick::Stick_R), ControllerResult::ControllerResult_InvalidControllerId);

        // 傾けて元に戻す
        EXPECT_EQ(hidInputerWrapper.m_TiltAnalogStickFunction(id, Stick::Stick_L, degree, power, g_DefaultWaitPress), ControllerResult::ControllerResult_InvalidControllerId);

        EXPECT_EQ(hidInputerWrapper.m_TiltAnalogStickFunction(id, Stick::Stick_R, degree, power, g_DefaultWaitPress), ControllerResult::ControllerResult_InvalidControllerId);
    }

    //-------------------------------------
    // 仕様範囲外の値入力
    //-------------------------------------

    for (int i = 0; i < g_AllControllerIndexRange; i++)
    {
        float degree = CreateDegree(true);
        float power = CreatePower(true);

        // 傾ける
        EXPECT_EQ(hidInputerWrapper.m_HoldAnalogStickFunction(i, Stick::Stick_L, degree, power), ControllerResult::ControllerResult_Success);

        EXPECT_EQ(hidInputerWrapper.m_HoldAnalogStickFunction(i, Stick::Stick_R, degree, power), ControllerResult::ControllerResult_Success);


        // 傾けて元に戻す
        EXPECT_EQ(hidInputerWrapper.m_TiltAnalogStickFunction(i, Stick::Stick_L, degree, power, g_DefaultWaitPress), ControllerResult::ControllerResult_Success);

        EXPECT_EQ(hidInputerWrapper.m_TiltAnalogStickFunction(i, Stick::Stick_R, degree, power, g_DefaultWaitPress), ControllerResult::ControllerResult_Success);
    }

    //-------------------------------------
    // 接続済みのコントローラーID の解除
    //-------------------------------------
    ReleaseAllController(&hidInputerWrapper );


    //-------------------------------------
    // 未接続のコントローラーに対して
    //-------------------------------------
    for (int i = 0; i < g_AllControllerIndexRange; i++)
    {
        float degree = CreateDegree(false);
        float power = CreatePower(false);

        // 傾ける
        EXPECT_EQ(hidInputerWrapper.m_HoldAnalogStickFunction(i, Stick::Stick_L, degree, power), ControllerResult::ControllerResult_InvalidControllerId);

        EXPECT_EQ(hidInputerWrapper.m_HoldAnalogStickFunction(i, Stick::Stick_R, degree, power), ControllerResult::ControllerResult_InvalidControllerId);


        // 傾きを解除
        EXPECT_EQ(hidInputerWrapper.m_ReleaseAnalogStickFunction(i, Stick::Stick_L), ControllerResult::ControllerResult_InvalidControllerId);

        EXPECT_EQ(hidInputerWrapper.m_ReleaseAnalogStickFunction(i, Stick::Stick_R), ControllerResult::ControllerResult_InvalidControllerId);

        // 傾けて元に戻す
        EXPECT_EQ(hidInputerWrapper.m_TiltAnalogStickFunction(i, Stick::Stick_L, degree, power, g_DefaultWaitPress), ControllerResult::ControllerResult_InvalidControllerId);

        EXPECT_EQ(hidInputerWrapper.m_TiltAnalogStickFunction(i, Stick::Stick_R, degree, power, g_DefaultWaitPress), ControllerResult::ControllerResult_InvalidControllerId);
    }

    // 全てのコントローラー接続を解除
    ReleaseAllController(&hidInputerWrapper );

    // 終了処理
    hidInputerWrapper.m_FinalizeFunction();
    // ライブラリ解放テスト
    ASSERT_TRUE(hidInputerWrapper.ReleaseHidLibrary());
}
