﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <Windows.h>
#include <iostream>
#include <cassert>
#include <autoTestAssistTool/HidInputerTypes.h>
#include <autoTestAssistTool/Common/autoTestAssistTool_LibTypes.h>

namespace hidInputer
{
    typedef HidInputerResult(*InitializeFunction)(const SerialNumberString& serialNumber);
    typedef HidInputerResult(*InitializeForLocalFunction)();
    typedef void(*FinalizeFunction)();

    typedef HidInputerResult (*BeginHidInputRecordingFunction)();
    typedef HidInputerResult (*EndHidInputRecordingFunction)();
    typedef HidInputerResult (*ExportHidInputRecordsWithPythonScriptFunction)( const char* exportFilename );

    typedef ControllerResult(*AddControllerFunction)(int *pOutControllerId);
    typedef ControllerResult(*AddControllerForIdFunction)(int controllerId);
    typedef ControllerResult(*ReleaseControllerFunction)(int controllerId);
    typedef ControllerResult(*AddDebugControllerFunction)(int *pOutControllerId);
    typedef ControllerResult(*AddControllerWithDeviceInfoFunction)(int *pOutControllerId, const ControllerDeviceInfo& deviceInfo);
    typedef ControllerResult(*GetConnectedControllerCountFunction)(int *pOutCount);
    typedef ControllerResult(*GetConnectedControllerIdsFunction)(int *pOutCount,
        int pOutIdsArray[], int arrayLength );
    typedef ControllerResult(*GetConnectedControllerDeviceInfoFunction)(ControllerDeviceInfo* pOutDeviceInfo,
        int controllerId);
    typedef ControllerResult(*GetConnectedDebugControllerCountFunction)(int *pOutCount);
    typedef ControllerResult(*GetConnectedDebugControllerIdsFunction)(int *pOutCount,
        int pOutIdsArray[], int arrayLength );
    typedef ControllerResult(*PressButtonFunction)(int controllerId, Button button);
    typedef ControllerResult(*ReleaseButtonFunction)(int controllerId, Button button);
    typedef ControllerResult(*PushButtonFunction)(int controllerId, Button button, int waitPress);
    typedef ControllerResult(*PressMultiButtonFunction)(int controllerId, Button buttonList[], int buttonNum);
    typedef ControllerResult(*ReleaseMultiButtonFunction)(int controllerId, Button buttonList[], int buttonNum);
    typedef ControllerResult(*PushMultiButtonFunction)(int controllerId, Button buttonList[], int buttonNum, int waitPress);
    typedef ControllerResult(*PushMultiSeqFunction)(int controllerId, Button buttonList[], int buttonNum, int waitPress, int waitSpan);
    typedef ControllerResult(*ResetControllerStateFunction)(int controllerId);
    typedef ControllerResult(*SetControllerStateFunction)(int controllerId, Button buttonList[], int buttonCount, Stick StickList[], float stickDegreeList[], float stickPowerList[], int stickCount);
    typedef ControllerResult(*HoldAnalogStickFunction)(int controllerId, Stick stick, float degree, float power);
    typedef ControllerResult(*ReleaseAnalogStickFunction)(int controllerId, Stick stick);
    typedef ControllerResult(*TiltAnalogStickFunction)(int controllerId, Stick stick, float degree, float power, int waitPress);
    typedef TouchResult(*TouchPressDownFunction)(int touchId, int x, int y);
    typedef TouchResult(*TouchPressDownWithFingerIdFunction)(int touchId, int x, int y, int fingerId);
    typedef TouchResult(*TouchPressUpFunction)(int touchId);
    typedef TouchResult(*TouchMoveFunction)(int touchId, int x, int y);
    typedef TouchResult(*TapFunction)(int touchId, int x, int y, int waitPress);
    typedef TouchResult(*DragAngleFunction)(int touchId, int startX, int startY, float angle, float length, int waitDuration, int waitSpan, bool releaseAfter);
    typedef TouchResult(*DragPosFunction)(int touchId, int startX, int startY, int endX, int endY, int waitDuration, int waitSpan, bool releaseAfter);
    typedef TouchResult(*MultiTapFunction)(int touchIdList[], int touchNum, float touchPosXList[], float touchPosYList[],
        int waitSpan);
    typedef TouchResult(*SetTouchStateFunction)(int touchIdList[], int fingerIdList[], float posXList[], float posYList[], int touchNum);
    typedef TouchResult(*MultiTouchAnimatorFunction)(int touchIdList[], int touchNum,
        int startCenterX, int startCenterY,
        float centerMoveDeg, float centerMoveLength,
        float touchRelativePosXList[], float touchRelativePosYList[],
        float coordsysStartDeg, float coordsysRotateDeg,
        float startScale, float increaseScale,
        int waitDuration, int waitSpan,
        int waitTouchBegin, int waitTouchEnd, bool releaseAfter);
    typedef TouchResult(*MultiDragPosFunction)(int touchIdList[], int touchNum,
        int startCenterX, int startCenterY,
        int endCenterX, int endCenterY,
        float touchRelativePosXList[], float touchRelativePosYList[],
        int waitDuration, int waitSpan,
        int waitTouchBegin, int waitTouchEnd, bool releaseAfter);
    typedef TouchResult(*MultiDragAngleFunction)(int touchIdList[], int touchNum,
        int startCenterX, int startCenterY,
        float centerMoveDeg, float centerMoveLength,
        float touchRelativePosXList[], float touchRelativePosYList[],
        int waitDuration, int waitSpan,
        int waitTouchBegin, int waitTouchEnd, bool releaseAfter);
    typedef TouchResult(*PinchFunction)(int touchIdList[], int touchNum,
        int centerX, int centerY,
        float touchDegList[],
        float startScale, float increaseScale,
        int waitDuration, int waitSpan,
        int waitTouchBegin, int waitTouchEnd, bool releaseAfter);
    typedef TouchResult(*CenterTouchPinchFunction)(int touchIdList[], int touchNum,
        int centerX, int centerY,
        float touchDegList[],
        float startScale, float increaseScale,
        int waitDuration, int waitSpan,
        int waitTouchBegin, int waitTouchEnd, bool releaseAfter);
    typedef TouchResult(*MultiRotateFunction)(int touchIdList[], int touchNum,
        int centerX, int centerY,
        float touchDegList[], float radius,
        float coordsysStartDeg, float coordsysRotateDeg,
        int waitDuration, int waitSpan,
        int waitTouchBegin, int waitTouchEnd, bool releaseAfter);
    typedef TouchResult(*CenterTouchMultiRotateFunction)(int touchIdList[], int touchNum,
        int centerX, int centerY,
        float touchDegList[], float radius,
        float coordsysStartDeg, float coordsysRotateDeg,
        int waitDuration, int waitSpan,
        int waitTouchBegin, int waitTouchEnd, bool releaseAfter);

    class HidInputerWrapper
    {
    public:
        HidInputerWrapper();
        ~HidInputerWrapper();

        bool LoadHidLibrary();
        bool ReleaseHidLibrary();
        bool LoadFunctiontions();

        // APIリスト
        InitializeFunction                      m_InitializeFunction;
        InitializeForLocalFunction              m_InitializeForLocalFunction;
        FinalizeFunction                        m_FinalizeFunction;

        AddControllerFunction                   m_AddControllerFunction;
        AddControllerForIdFunction              m_AddControllerForIdFunction;
        ReleaseControllerFunction               m_ReleaseControllerFunction;
        AddDebugControllerFunction              m_AddDebugControllerFunction;
        AddControllerWithDeviceInfoFunction     m_AddControllerWithDeviceInfoFunction;
        GetConnectedControllerCountFunction     m_GetConnectedControllerCountFunction;
        GetConnectedControllerIdsFunction       m_GetConnectedControllerIdsFunction;
        GetConnectedControllerDeviceInfoFunction m_GetConnectedControllerDeviceInfoFunction;
        GetConnectedDebugControllerCountFunction m_GetConnectedDebugControllerCountFunction;
        GetConnectedDebugControllerIdsFunction   m_GetConnectedDebugControllerIdsFunction;
        PressButtonFunction                     m_PressButtonFunction;
        ReleaseButtonFunction                   m_ReleaseButtonFunction;
        PushButtonFunction                      m_PushButtonFunction;
        PressMultiButtonFunction                m_PressMultiButtonFunction;
        ReleaseMultiButtonFunction              m_ReleaseMultiButtonFunction;
        PushMultiButtonFunction                 m_PushMultiButtonFunction;
        PushMultiSeqFunction                    m_PushMultiSeqFunction;
        ResetControllerStateFunction            m_ResetControllerStateFunction;
        SetControllerStateFunction              m_SetControllerStateFunction;
        HoldAnalogStickFunction                 m_HoldAnalogStickFunction;
        ReleaseAnalogStickFunction              m_ReleaseAnalogStickFunction;
        TiltAnalogStickFunction                 m_TiltAnalogStickFunction;
        TouchPressDownFunction                  m_TouchPressDownFunction;
        TouchPressDownWithFingerIdFunction      m_TouchPressDownWithFingerIdFunction;
        TouchPressUpFunction                    m_TouchPressUpFunction;
        TouchMoveFunction                       m_TouchMoveFunction;
        TapFunction                             m_TapFunction;
        DragAngleFunction                       m_DragAngleFunction;
        DragPosFunction                         m_DragPosFunction;
        SetTouchStateFunction                   m_SetTouchStateFunction;
        MultiTapFunction                        m_MultiTapFunction;
        MultiTouchAnimatorFunction              m_MultiTouchAnimatorFunction;
        MultiDragPosFunction                    m_MultiDragPosFunction;
        MultiDragAngleFunction                  m_MultiDragAngleFunction;
        PinchFunction                           m_PinchFunction;
        CenterTouchPinchFunction                m_CenterTouchPinchFunction;
        MultiRotateFunction                     m_MultiRotateFunction;
        CenterTouchMultiRotateFunction          m_CenterTouchMultiRotateFunction;

        BeginHidInputRecordingFunction  m_BeginHidInputRecordingFunction;
        EndHidInputRecordingFunction    m_EndHidInputRecordingFunction;
        ExportHidInputRecordsWithPythonScriptFunction m_ExportHidInputRecordsWithPythonScriptFunction;

    private:

        bool LoadControllerFunctions();
        bool LoadButtonStickFunctions();
        bool LoadTouchScreenFunctions();
        bool LoadRecordingFunctions();

        HMODULE     m_ModuleHandle;

    };
}
