﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "CaptureProcessorWrapper.h"
#include "..\Common\testAutoTestAssistTool_Util.h"
#include <nnt/nntest.h>
#include <tchar.h>
#define DEBUG_LOG(...) printf(__VA_ARGS__)

namespace captureProcessor
{
    CaptureProcessorWrapper::CaptureProcessorWrapper()
    {
    }

    CaptureProcessorWrapper::~CaptureProcessorWrapper()
    {
    }

    bool CaptureProcessorWrapper::LoadCaptureLibrary()
    {
        auto libPath = autoTestAssistTool::util::GetSdkRootPath().append(
            "\\Tools\\AutoTestAssistTools\\Libraries\\CaptureProcessor.dll");
        m_ModuleHandle = ::LoadLibraryA(libPath.c_str());
        return (m_ModuleHandle != NULL);
    }

    bool CaptureProcessorWrapper::ReleaseCaptureLibrary()
    {
        this->m_FinalizeFunction();

        int result =  FreeLibrary(m_ModuleHandle);

        if (result == 0)
        {
            return false;
        }
        return true;
    }

    bool CaptureProcessorWrapper::LoadFunctiontions()
    {
        bool loadLibraryResult = true;

        m_InitializeForCaptureDeviceFunction = (InitializeForCaptureDeviceFunction)GetProcAddress(m_ModuleHandle, "InitializeForCaptureDevice");
        if (m_InitializeForCaptureDeviceFunction == NULL)
        {
            DEBUG_LOG("Initialize is not found");
            loadLibraryResult = false;
        }

        m_InitializeForDevkitCapture = (InitializeForDevkitCapture)GetProcAddress(m_ModuleHandle, "InitializeForDevkitCapture");
        if (m_InitializeForDevkitCapture == NULL)
        {
            DEBUG_LOG("InitializeForDevkitCapture is not found");
            loadLibraryResult = false;
        }

        m_FinalizeFunction = (FinalizeFunction)GetProcAddress(m_ModuleHandle, "Finalize");
        if (m_FinalizeFunction == NULL)
        {
            DEBUG_LOG("Finalize is not found");
            loadLibraryResult = false;
        }

        m_GetCaptureDeviceCountFunction = (GetCaptureDeviceCountFunction)GetProcAddress(m_ModuleHandle, "GetCaptureDeviceCount");
        if (m_GetCaptureDeviceCountFunction == NULL)
        {
            DEBUG_LOG("GetCaptureDeviceCount is not found");
            loadLibraryResult = false;
        }

        m_GetCaptureDeviceNameFunction = (GetCaptureDeviceNameFunction)GetProcAddress(m_ModuleHandle, "GetCaptureDeviceName");
        if (m_GetCaptureDeviceNameFunction == NULL)
        {
            DEBUG_LOG("GetCaptureDeviceName is not found");
            loadLibraryResult = false;
        }

        m_GetDotColorFunction = (GetDotColorFunction)GetProcAddress(m_ModuleHandle, "GetDotColor");
        if(m_GetDotColorFunction == NULL)
        {
            DEBUG_LOG("GetDotColor is not found");
            loadLibraryResult = false;
        }

        m_DetectDotColorFunction = (DetectDotColorFunction)GetProcAddress(m_ModuleHandle, "DetectDotColor");
        if(m_DetectDotColorFunction == NULL)
        {
            DEBUG_LOG("DetectDotColor is not found");
            loadLibraryResult = false;
        }

        m_WaitDetectDotColorFunction = (WaitDetectDotColorFunction)GetProcAddress(m_ModuleHandle, "WaitDetectDotColor");
        if(m_WaitDetectDotColorFunction == NULL)
        {
            DEBUG_LOG("WaitDetectDotColor is not found");
            loadLibraryResult = false;
        }

        m_ExecuteLabelingFunction = (ExecuteLabelingFunction)GetProcAddress(m_ModuleHandle, "ExecuteLabeling");
        if(m_ExecuteLabelingFunction == NULL)
        {
            DEBUG_LOG("ExecuteLabeling is not found");
            loadLibraryResult = false;
        }

        m_GetLabelingResultsFunction = (GetLabelingResultsFunction)GetProcAddress(m_ModuleHandle, "GetLabelingResults");
        if(m_GetLabelingResultsFunction == NULL)
        {
            DEBUG_LOG("GetLabelingResults is not found");
            loadLibraryResult = false;
        }

        m_ReleaseLabelingResultFunction = (ReleaseLabelingResultFunction)GetProcAddress(m_ModuleHandle, "ReleaseLabelingResult");
        if (m_ReleaseLabelingResultFunction == NULL)
        {
            DEBUG_LOG("ReleaseLabelingResult is not found");
            loadLibraryResult = false;
        }

        loadLibraryResult = loadLibraryResult & LoadImageFunctions();
        loadLibraryResult = loadLibraryResult & LoadFilterFunctions();
        loadLibraryResult = loadLibraryResult & LoadOcrFunctions();
        loadLibraryResult = loadLibraryResult & LoadDetectObjectFunctions();

        return loadLibraryResult;
    }

    bool CaptureProcessorWrapper::LoadImageFunctions()
    {
        bool loadLibraryResult = true;

        m_GetImageFromCaptureDeviceFunction = (GetImageFromCaptureDeviceFunction)GetProcAddress(m_ModuleHandle, "GetImageFromCaptureDevice");
        if (m_GetImageFromCaptureDeviceFunction == NULL)
        {
            DEBUG_LOG("GetImageFromCaptureDevice is not found");
            loadLibraryResult = false;
        }

        m_LoadImageFileFunction = (LoadImageFileFunction)GetProcAddress(m_ModuleHandle, "LoadImageFile");
        if (m_LoadImageFileFunction == NULL)
        {
            DEBUG_LOG("LoadImageFile is not found");
            loadLibraryResult = false;
        }

        m_SaveImageFileFunction = (SaveImageFileFunction)GetProcAddress(m_ModuleHandle, "SaveImageFile");
        if (m_SaveImageFileFunction == NULL)
        {
            DEBUG_LOG("SaveImageFile is not found");
            loadLibraryResult = false;
        }

        m_ReleaseImageFunction = (ReleaseImageFunction)GetProcAddress(m_ModuleHandle, "ReleaseImage");
        if (m_ReleaseImageFunction == NULL)
        {
            DEBUG_LOG("ReleaseImage is not found");
            loadLibraryResult = false;
        }

        m_ReleaseAllImagesFunction = (ReleaseAllImagesFunction)GetProcAddress(m_ModuleHandle, "ReleaseAllImages");
        if (m_ReleaseAllImagesFunction == NULL)
        {
            DEBUG_LOG("ReleaseAllImages is not found");
            loadLibraryResult = false;
        }

        m_GetImageSizeFunction = (GetImageSizeFunction)GetProcAddress(m_ModuleHandle, "GetImageSize");
        if (m_GetImageSizeFunction == NULL)
        {
            DEBUG_LOG("GetImageSize is not found");
            loadLibraryResult = false;
        }

        m_GetImageDataFunction = (GetImageDataFunction)GetProcAddress(m_ModuleHandle, "GetImageData");
        if (m_GetImageDataFunction == NULL)
        {
            DEBUG_LOG("GetImageData is not found");
            loadLibraryResult = false;
        }

        m_OpenImageWindowFunction = (OpenImageWindowFunction)GetProcAddress(m_ModuleHandle, "OpenImageWindow");
        if(m_OpenImageWindowFunction == NULL)
        {
            DEBUG_LOG("OpenImageWindow is not found");
            loadLibraryResult = false;
        }

        m_CloseImageWindowFunction = (CloseImageWindowFunction)GetProcAddress(m_ModuleHandle, "CloseImageWindow");
        if(m_CloseImageWindowFunction == NULL)
        {
            DEBUG_LOG("CloseImageWindow is not found");
            loadLibraryResult = false;
        }

        m_ExtractImageFunction = (ExtractImageFunction)GetProcAddress(m_ModuleHandle, "ExtractImage");
        if(m_ExtractImageFunction == NULL)
        {
            DEBUG_LOG("ExtractImage is not found");
            loadLibraryResult = false;
        }

        return loadLibraryResult;
    }

    bool CaptureProcessorWrapper::LoadFilterFunctions()
    {
        bool loadLibraryResult = true;
        m_CreateFilterFunction = (CreateFilterFunction)GetProcAddress(m_ModuleHandle, "CreateFilter");
        if(m_CreateFilterFunction == NULL)
        {
            DEBUG_LOG("CreateFilter is not found");
            loadLibraryResult = false;
        }

        m_DeleteFilterFunction = (DeleteFilterFunction)GetProcAddress(m_ModuleHandle, "DeleteFilter");
        if(m_DeleteFilterFunction == NULL)
        {
            DEBUG_LOG("DeleteFilter is not found");
            loadLibraryResult = false;
        }

        m_ApplyFilterFunction = (ApplyFilterFunction)GetProcAddress(m_ModuleHandle, "ApplyFilter");
        if(m_ApplyFilterFunction == NULL)
        {
            DEBUG_LOG("ApplyFilter is not found");
            loadLibraryResult = false;
        }

        m_SetBinarizationFilterFunction = (SetBinarizationFilterFunction)GetProcAddress(m_ModuleHandle, "SetBinarizationFilter");
        if(m_SetBinarizationFilterFunction == NULL)
        {
            DEBUG_LOG("SetBinarizationFilter is not found");
            loadLibraryResult = false;
        }

        m_SetColorRangeFilterFunction = (SetColorRangeFilterFunction)GetProcAddress(m_ModuleHandle, "SetColorRangeFilter");
        if(m_SetColorRangeFilterFunction == NULL)
        {
            DEBUG_LOG("SetColorRangeFilter is not found");
            loadLibraryResult = false;
        }

        m_SetMorphologyFilterFunction = (SetMorphologyFilterFunction)GetProcAddress(m_ModuleHandle, "SetMorphologyFilter");
        if(m_SetMorphologyFilterFunction == NULL)
        {
            DEBUG_LOG("SetMorphologyFilter is not found");
            loadLibraryResult = false;
        }

        return loadLibraryResult;
    }

    bool CaptureProcessorWrapper::LoadOcrFunctions()
    {
        bool loadLibraryResult = true;

        m_DetectTextForImageFunction = (DetectTextForImageFunction)GetProcAddress(m_ModuleHandle, "DetectTextForImage");
        if(m_DetectTextForImageFunction == NULL)
        {
            DEBUG_LOG("DetectTextForImage is not found");
            loadLibraryResult = false;
        }

        m_ExecuteOcrFunction = (ExecuteOcrFunction)GetProcAddress(m_ModuleHandle, "ExecuteOcr");
        if(m_ExecuteOcrFunction == NULL)
        {
            DEBUG_LOG("ExecuteOcr is not found");
            loadLibraryResult = false;
        }

        m_GetOcrResultStringSizeFunction = (GetOcrResultStringSizeFunction)GetProcAddress(m_ModuleHandle, "GetOcrResultStringSize");
        if(m_GetOcrResultStringSizeFunction == NULL)
        {
            DEBUG_LOG("GetOcrResultStringSize is not found");
            loadLibraryResult = false;
        }

        m_GetOcrResultStringFunction = (GetOcrResultStringFunction)GetProcAddress(m_ModuleHandle, "GetOcrResultString");
        if(m_GetOcrResultStringFunction == NULL)
        {
            DEBUG_LOG("GetOcrResultString is not found");
            loadLibraryResult = false;
        }

        m_ReleaseOcrResultFunction = (ReleaseOcrResultFunction)GetProcAddress(m_ModuleHandle, "ReleaseOcrResult");
        if (m_ReleaseOcrResultFunction == NULL)
        {
            DEBUG_LOG("ReleaseOcrResult is not found");
            loadLibraryResult = false;
        }
        return loadLibraryResult;
    }

    bool CaptureProcessorWrapper::LoadDetectObjectFunctions()
    {
        bool loadLibraryResult = true;

        m_DetectObjectFunction = (DetectObjectFunction)GetProcAddress(m_ModuleHandle, "DetectObject");
        if (m_DetectObjectFunction == NULL)
        {
            DEBUG_LOG("DetectObject is not found");
            loadLibraryResult = false;
        }

        m_WaitDetectObjectFunction = (WaitDetectObjectFunction)GetProcAddress(m_ModuleHandle, "WaitDetectObject");
        if (m_WaitDetectObjectFunction == NULL)
        {
            DEBUG_LOG("WaitDetectObject is not found");
            loadLibraryResult = false;
        }

        m_DetectObjectWithFilterFunction = (DetectObjectWithFilterFunction)GetProcAddress(m_ModuleHandle, "DetectObjectWithFilter");
        if(m_DetectObjectWithFilterFunction == NULL)
        {
            DEBUG_LOG("DetectObjectWithFilter is not found");
            loadLibraryResult = false;
        }

        m_WaitDetectObjectWithFilterFunction = (WaitDetectObjectWithFilterFunction)GetProcAddress(m_ModuleHandle, "WaitDetectObjectWithFilter");
        if(m_WaitDetectObjectWithFilterFunction == NULL)
        {
            DEBUG_LOG("WaitDetectObjectWithFilter is not found");
            loadLibraryResult = false;
        }

        return loadLibraryResult;
    }
}
