﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Text.RegularExpressions;

namespace ProdTestTool
{
    class Sync
    {
        private static bool IsTarget(out bool isOnCardPatch, string romId)
        {
            var args = string.Format("-x {0} -k \"{1}/{2}\"", Constant.Proxy, Constant.DbHostUrl, romId);
            var pattern = @"(""status"":"")(?<status>.*)("","".*)";
            bool isMatch = false;
            int retry = 0;
            const int RetryCountMax = 3;
            var result = string.Empty;
            while (!isMatch && retry < RetryCountMax)
            {
                result = Common.ExecuteCommand(Constant.Curl, args, true);
                isMatch = Regex.IsMatch(result, pattern);
                retry++;
            }
            if (!isMatch)
            {
                Console.WriteLine("-- Result begin ");
                Console.WriteLine(result);
                Console.WriteLine("-- Result end ");
                throw new InvalidOperationException();
            }
            if (Regex.IsMatch(result, @"(""original_rom_id"":"")(.*)("","".*)"))
            {
                // original_rom_id の要素がある場合は OnCardPatch
                isOnCardPatch = true;
            }
            else
            {
                isOnCardPatch = false;
            }
            var match = Regex.Match(result, pattern);
            var status = match.Groups["status"].Value;
            return status == "APPROVED" || status == "PROMOTE";
        }

        private static bool IsAlreadySynced(string romId)
        {
            return Directory.Exists(Common.MakeInfoDir(romId));
        }

        private static int ParseBrowsed(ref List<string> romIds, string browseCmdOut)
        {
            int count = 0;
            using (var sr = new StringReader(browseCmdOut))
            {
                while (sr.Peek() > -1)
                {
                    var line = sr.ReadLine();
                    if (!line.StartsWith("dv--"))
                    {
                        continue;
                    }
                    var pattern = @"(dv--  0    )(?<romId>.*)";
                    if (Regex.IsMatch(line, pattern))
                    {
                        var match = Regex.Match(line, pattern);
                        var romId = match.Groups["romId"].Value;
                        if (romId.Length != 32)
                        {
                            continue;
                        }
                        romIds.Add(romId);
                        count++;
                    }
                }
            }
            return count;
        }

        public static void SyncNspInfo()
        {
            var romIds = new List<string>();
            int count = 0;
            while (true)
            {
                var args = string.Format("shares browse -v -i -H{0} -u{1} -p{2} -T{3} -k{4} -P\"{5}\"", Constant.HostName, Constant.UserName, Constant.PassWord, Constant.Port, count, Constant.RomRootDir);
                var result = Common.ExecuteCommand(Constant.Aspera, args);
                var browsed = ParseBrowsed(ref romIds, result);
                count += browsed;
                if (browsed == 0)
                {
                    break;
                }
            }

            foreach (var romId in romIds)
            {
                var srcPath = Constant.RomRootDir + string.Format("/{0}/dump", romId);
                var dstPath = Common.MakeInfoDir(romId);

                bool isOnCardPatch = false;
                var flagFilePath = Path.Combine(dstPath, "thisIsOnCardPatch");

                if (IsAlreadySynced(romId))
                {
                    continue;
                }

                if (!IsTarget(out isOnCardPatch, romId))
                {
                    continue;
                }

                {
                    var args = string.Format("shares download -v -i -H{0} -u{1} -p{2} -T{3} -s\"{4}\" -d\"{5}\"", Constant.HostName, Constant.UserName, Constant.PassWord, Constant.Port, srcPath, dstPath);
                    Common.ExecuteCommand(Constant.Aspera, args);
                    if (isOnCardPatch)
                    {
                        File.Create(flagFilePath);
                    }
                }
            }
        }
    }
}
