﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using Nintendo.Authoring.AuthoringLibrary;

namespace AuthoringToolsTest
{
    [TestClass]
    public class IndirectStorageSourceTest
    {
        [TestMethod]
        public void TestBuildWithException()
        {
            var oldData = new byte[0];
            var oldSource = new MemorySource(oldData, 0, oldData.Length);
            var newData = new byte[0];
            var newSource = new MemorySource(newData, 0, newData.Length);
            using (var source = new IndirectStorageSource(false))
            {
                try
                {
                    source.Build(oldSource, newSource, null);
                }
                catch (Exception e)
                {
                    Assert.IsTrue(e.Message.Contains("Failed to Build IndirectStorageBuilder"));
                }
            }
        }

        [TestMethod]
        public void TestDisposeWithoutBuild()
        {
            using (var source = new IndirectStorageSource(false))
            {
            }
        }
    }
}
