﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test.MainWindow.ProjectEditPanel.Params
{
    public class AocContentVmTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void DefaultCtor()
        {
            var newAocContentVm = new AocContentVm(
                _context.DiContainer,
                new AocContent(
                    _context.DiContainer,
                    new AocMeta()
                ),
                _context.DiContainer.GetInstance<Project>()
            );

            using (var vm = newAocContentVm)
            {
                Assert.NotNull(vm.Title);
                Assert.NotNull(vm.Model);
                Assert.NotNull(vm.Params);
                Assert.NotEmpty(vm.Params);
                Assert.NotNull(vm.HasErrors);
            }
        }
    }
}
