﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Linq;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.Core.Test.Fixtures;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Pages;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test.MainWindow.ProjectEditPanel.Pages
{
    public class TitlePageVmOnNspTest : IDisposable, IClassFixture<BuildTestAppNspFixture>
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        private readonly BuildTestAppNspFixture _fixture;

        public TitlePageVmOnNspTest(BuildTestAppNspFixture fixture)
        {
            _fixture = fixture.Initialize();
        }

        [Theory]
        [InlineData(false)]
        [InlineData(true)]
        public void NoIconTitleCannotReplaceIcon(bool isReadOnly)
        {
            var app = _context.DiContainer.GetInstance<App>();
            app.Project = Project.Import(_context.DiContainer, ImportableFileType.Nsp, _fixture.NspFilePath);
            app.Project.Meta.IsReadOnly = isReadOnly;

            var appProfile = _context.DiContainer.GetInstance<AppProfile>();
            appProfile.AppMode = AppModeType.ApplicationNsp;

            using (var vm = _context.DiContainer.GetInstance<TitlePageVm>())
            {
                Assert.True(vm.TitleParam.Titles.Any());

                // アイコン設定済みのタイトル
                {
                    var titleVm = vm.TitleParam.Titles.FirstOrDefault(x => x.Language.Value == LanguageType.AmericanEnglish);
                    Assert.NotNull(titleVm);
                    Assert.Equal(isReadOnly, titleVm.IconFilePath.IsReadOnly.Value);
                }

                // アイコン未設定のタイトル
                {
                    var canTitleAddOrRemove = app.Project.AppCapability.IsSupportNspTitleAddOrRemove;
                    var titleVm = vm.TitleParam.Titles.FirstOrDefault(x => x.Language.Value == LanguageType.Japanese);
                    Assert.NotNull(titleVm);

                    if (canTitleAddOrRemove)
                        Assert.Equal(isReadOnly, titleVm.IconFilePath.IsReadOnly.Value);
                    else
                        Assert.Equal(true, titleVm.IconFilePath.IsReadOnly.Value);
                }
            }

        }
    }
}
