﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.Core.Test;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Pages;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Params;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test.MainWindow.ProjectEditPanel.Pages
{
    public class TemporaryDataAreaPageVmTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void DefaultCtor()
        {
            using (var vm = _context.DiContainer.GetInstance<TemporaryDataAreaPageVm>())
            {
                Assert.NotEmpty(vm.Params);
                Assert.False(vm.HasErrors.Value);
            }
        }


        [Fact]
        public void TemporaryStorageSize()
        {
            using (var project = _context.DiContainer.GetInstance<Project>())
            using (var vm = _context.DiContainer.GetInstance<TemporaryDataAreaPageVm>())
            {
                if (project.AppCapability.IsSupportTempAndCacheStorage == false)
                    return;

                var a = project.Meta.Application;

                Assert.False(vm.HasErrors.Value);

                a.IsUseTemporaryStorageSize = true;
                Assert.False(vm.HasErrors.Value);
                Assert.NotEmpty(vm.TemporaryStorageSize.WarningMessage.Value);

                a.TemporaryStorageSize = 1024 * 1024;
                Assert.False(vm.HasErrors.Value);
                Assert.Null(vm.TemporaryStorageSize.WarningMessage.Value);

                a.TemporaryStorageSize = 1024 * 1024 * 4001L;
                Assert.False(vm.HasErrors.Value);
                Assert.NotEmpty(vm.TemporaryStorageSize.WarningMessage.Value);

                a.TemporaryStorageSize = 1024 * 1024 * 4000L - 1L;
                Assert.False(vm.HasErrors.Value);
                Assert.NotEmpty(vm.TemporaryStorageSize.WarningMessage.Value);

                a.IsUseTemporaryStorageSize = false;
                Assert.Null(vm.TemporaryStorageSize.WarningMessage.Value);
            }
        }

        [Theory]
        [InlineData(nameof(Application.CacheStorageSize), nameof(Application.IsUseCacheStorageSize))]
        [InlineData(nameof(Application.CacheStorageJournalSize), nameof(Application.IsUseCacheStorageJournalSize))]
        public void CacheStorageSize(string propertyName, string isUse)
        {
            using (var project = _context.DiContainer.GetInstance<Project>())
            using (var vm = _context.DiContainer.GetInstance<TemporaryDataAreaPageVm>())
            {
                if (project.AppCapability.IsSupportTempAndCacheStorage == false)
                    return;

                var a = project.Meta.Application;

                Assert.False(vm.HasErrors.Value);

                a.SetPropertyValue(isUse, true);
                Assert.False(vm.HasErrors.Value);

                var paramVm = vm.GetPropertyValue<CapacityParamVm>(propertyName);
                Assert.NotEmpty(paramVm.WarningMessage.Value);

                a.SetPropertyValue(propertyName, 1024 * 16);
                Assert.False(vm.HasErrors.Value);
                Assert.Null(paramVm.WarningMessage.Value);

                a.SetPropertyValue(propertyName, 1024 * 16 + 1);
                Assert.False(vm.HasErrors.Value);
                Assert.NotEmpty(paramVm.WarningMessage.Value);

                a.SetPropertyValue(isUse, false);
                Assert.Null(paramVm.WarningMessage.Value);
            }
        }
    }
}
