﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using Nintendo.Authoring.AuthoringEditor.Core;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test
{
    public class GuiConstantsTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void Width()
        {
            // ReSharper disable HeuristicUnreachableCode
            Assert.True(GuiConstants.ExtraSmallWidth < GuiConstants.SemiSmallWidth);
            Assert.True(GuiConstants.SemiSmallWidth < GuiConstants.SmallWidth);
            Assert.True(GuiConstants.SmallWidth < GuiConstants.MiddleWidth);
            Assert.True(GuiConstants.MiddleWidth < GuiConstants.LargeWidth);
            Assert.True(GuiConstants.LargeWidth < GuiConstants.ExtraLargeWidth);
            // ReSharper restore HeuristicUnreachableCode
        }

        [Fact]
        public void MessageKey()
        {
            Assert.NotNull(GuiConstants.MessageKey_Dialog);
            Assert.NotNull(GuiConstants.MessageKey_FileOpen);
            Assert.NotNull(GuiConstants.MessageKey_FileSave);
            Assert.NotNull(GuiConstants.MessageKey_DirectoryOpen);
        }

        public static IEnumerable<object[]> AllImportableFileType =>
            Enum.GetValues(typeof(ImportableFileType)).Cast<ImportableFileType>().Select(t => new object[] {t});

        [Theory]
        [MemberData(nameof(AllImportableFileType))]
        public void ImportableFileDict(ImportableFileType type)
        {
            Assert.True(GuiConstants.ImportableFileDict.ContainsKey(type));

            var d = GuiConstants.ImportableFileDict[type];

            Assert.NotNull(d.DialogFilter);
            Assert.NotNull(d.NoName);
        }
    }
}
