﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Foundation.Test
{
    public class StreamHelperTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        public static IEnumerable<object> IsEqualData => new[]
        {
            new object[] {true, null, null},
            new object[] {false, new MemoryStream(new byte[] {1, 2, 3}), null},
            new object[] {false, null, new MemoryStream(new byte[] {1, 2, 3})},
            new object[] {false, new MemoryStream(new byte[] {1, 2, 3, 4}), new MemoryStream(new byte[] {1, 2, 3})},
            new object[] {false, new MemoryStream(new byte[] {4, 5, 6}), new MemoryStream(new byte[] {1, 2, 3})},
            new object[] {true, new MemoryStream(new byte[] {1, 2, 3}), new MemoryStream(new byte[] {1, 2, 3})},
            new object[] {true, new MemoryStream(new byte[0]), new MemoryStream(new byte[0])}
        };

        [Theory]
        [MemberData(nameof(IsEqualData))]
        public void IsEqual(bool expected, Stream b1, Stream b2)
        {
            Assert.Equal(expected, StreamHelper.IsEqual(b1, b2));
        }
    }
}
