﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.IO;
using System.Linq;
using System.Xml.Serialization;
using Nintendo.Authoring.AuthoringEditor.Core.Test.Fixtures;
using Nintendo.Authoring.AuthoringEditor.Foundation;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Core.Test
{
    public class ProgramInfoTest : IDisposable, IClassFixture<BuildTestAppNspFixture>
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        private readonly BuildTestAppNspFixture _fixture;

        public ProgramInfoTest(BuildTestAppNspFixture fixture)
        {
            _fixture = fixture.Initialize();
        }

        [Fact]
        public void ImportableProgramInfo()
        {
            var nspFile = new NspFile(_fixture.NspFilePath)
            {
                EnumerationMode = NspFileEnumeration.RootOnly
            };

            var programInfoFile = nspFile.Files(new NspFileEnumerateParameter { EnumerationType = NspFileEnumeration.All })
                .FirstOrDefault(x => x.FilePath.EndsWith(".programinfo.xml"));
            Assert.NotNull(programInfoFile);

            var programInfoXml = nspFile.ReadAllText(programInfoFile.FilePath);
            Assert.NotEmpty(programInfoXml);

            var programInfo = (ProgramInfo)new XmlSerializer(typeof(ProgramInfo))
                .Deserialize(new StringReader(programInfoXml));

            Assert.NotNull(programInfo);
            Assert.False(string.IsNullOrWhiteSpace(programInfo.SdkVersion));
            Assert.False(string.IsNullOrWhiteSpace(programInfo.ToolVersion));
            Assert.False(string.IsNullOrWhiteSpace(programInfo.BuildType));
            Assert.NotEmpty(programInfo.Middlewares);
        }

    }
}
