﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nw.g3d.nw4f_3dif;
using nw.g3d.iflib;
using System.Reflection;
using System.IO;

namespace _3dToolsTestUtility
{
    public static class IoUtility
    {
        public static string NormalizeFilePath(string path)
        {
            FileInfo fileInfo = new FileInfo(path);
            return fileInfo.FullName;
        }

        /// <summary>
        /// 中間ファイルを読み込みます。
        /// </summary>
        /// <param name="streamList">ストリームリストです。</param>
        /// <param name="fileName">中間ファイル名です。</param>
        /// <param name="xsdBasePath">GetXsdBasePath()の値を入れます。</param>
        /// <returns>中間ファイルを返します。</returns>
        public static nw4f_3difType ReadFile(List<G3dStream> streamList, string fileName, string xsdBasePath)
        {
            G3dParallel.Job = 1;
            nw4f_3difType nw4f_3dif = null;
            if (G3dPath.IsStreamBinaryPath(fileName))
            {
                nw4f_3dif = IfBinaryReadUtility.Read(streamList, fileName, xsdBasePath);
            }
            else
            {
                nw4f_3dif = IfReadUtility.Read(streamList, fileName, xsdBasePath);
            }
            return nw4f_3dif;
        }

        public static string GetTempFolderPath()
        {
            return GetTempPath(string.Empty);
        }

        public static string GetTempFilePath(string baseFileName)
        {
            return GetTempPath($"_{baseFileName}");
        }

        public static string GetSdkRootPath()
        {
            return System.IO.Path.Combine(
                System.IO.Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location),
                "../../../../../../..");
        }

        public static string Get3dToolsRootPath()
        {
            return System.IO.Path.Combine(
                GetSdkRootPath(),
                "Tools/Graphics/3dTools");
        }

        public static string GetG3dDemoRootPath()
        {
            return System.IO.Path.Combine(
                GetSdkRootPath(),
                "Samples/Sources/Applications/G3dDemo");
        }

        public static string GetXsdBasePath()
        {
            return System.IO.Path.Combine(
                GetSdkRootPath(),
                "Programs/NintendoWare/Sources/Tools/Graphics/3dTools/3dIntermediateFileXsd");
        }

        public static void WriteLogLine(string message)
        {
            Console.Out.WriteLine(message);
            Console.Out.Flush();
        }

        public static void WriteErrorLine(string message)
        {
            Console.Error.WriteLine(message);
            Console.Error.Flush();
        }

        private static string GetTempPath(string baseName)
        {
            string suffix = $"_{baseName}";
            if (string.IsNullOrEmpty(baseName))
            {
                suffix = string.Empty;
            }

            return System.IO.Path.Combine(
                System.IO.Path.GetTempPath(),
                $"Nintendo_{Assembly.GetExecutingAssembly().GetName().Name}_{Guid.NewGuid().ToString("N")}{suffix}");
        }
    }
}
