﻿using System;
using System.Text;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using nw.g3d.iflib;
using nw.g3d.nw4f_3dif;
using _3dToolsTestUtility;
using System.Linq;

namespace _3dIntermediateFileLibraryTest
{
    /// <summary>
    /// 中間ファイルオプティマイザーの --rigid-body-to-rigid-skinning の内部実装テストです。
    /// </summary>
    [TestClass]
    public class RigidBodyToRigidSkinningTest
    {
        [TestMethod]
        public void TestCompressEnable()
        {
            var model = ModelDataCreationUtility.CreateEmptyModel();
            List<G3dStream> streams = new List<G3dStream>();

            //
            // 以下のようなボーン構造を用意
            //
            // boneRoot
            // |_boneCompressEnabled_E(compress_enable=true)
            //   |_boneCompressDisabled(compress_enable=false)
            //     |_boneCompressEnabled_D(compress_enable=true)
            //       |_boneCompressEnabled_C(compress_enable=true)
            //       | |_boneCompressEnabled_A(compress_enable=true)
            //       |   |_shapeA
            //       |_boneCompressEnabled_B(compress_enable=true)
            //         |_shapeB
            //
            ModelDataCreationUtility.AddBone(model, "boneRoot", string.Empty);
            ModelDataCreationUtility.AddBone(model, "boneCompressEnabled_E", "boneRoot");
            boneType boneCompressDisabled = ModelDataCreationUtility.AddBone(model, "boneCompressDisabled", "boneCompressEnabled_E");
            ModelDataCreationUtility.AddBone(model, "boneCompressEnabled_D", "boneCompressDisabled");
            ModelDataCreationUtility.AddBone(model, "boneCompressEnabled_C", "boneCompressEnabled_D");
            ModelDataCreationUtility.AddBone(model, "boneCompressEnabled_A", "boneCompressEnabled_C");
            ModelDataCreationUtility.AddBone(model, "boneCompressEnabled_B", "boneCompressEnabled_D");
            boneCompressDisabled.compress_enable = false;

            var indexStreamShapeA = new G3dStream(new int[] { 0, 1, 2 }, 3);
            streams.Add(indexStreamShapeA);
            var indexStreamShapeB = new G3dStream(new int[] { 2, 0, 1 }, 3);
            streams.Add(indexStreamShapeB);
            var positionStreamShapeA = new G3dStream(new float[]
                {
                    0.0f, 1.0f, 2.0f,
                    0.1f, 1.1f, 2.1f,
                    0.2f, 1.2f, 2.2f,
                }, 3);
            streams.Add(positionStreamShapeA);
            var positionStreamShapeB = new G3dStream(new float[]
                {
                    2.0f, 0.0f, 1.0f,
                    2.1f, 0.1f, 1.1f,
                    2.2f, 0.2f, 1.2f,
                }, 3);
            streams.Add(positionStreamShapeB);
            model.stream_array = G3dStreamUtility.ToStreamArray(streams);

            ModelDataCreationUtility.AddVertexAttribute(model, new VertexAttr[]
                {
                    new VertexAttr()
                    {
                        Name = "_p0",
                        Hint = "position0",
                        StreamIndex = streams.IndexOf(positionStreamShapeA),
                        Type = vtx_attrib_typeType.float3,
                    },
                });

            ModelDataCreationUtility.AddVertexAttribute(model, new VertexAttr[]
                {
                    new VertexAttr()
                    {
                        Name = "_p0",
                        Hint = "position0",
                        StreamIndex = streams.IndexOf(positionStreamShapeB),
                        Type = vtx_attrib_typeType.float3,
                    },
                });

            ModelDataCreationUtility.AddShape(model, "shapeA", "matA", "boneCompressEnabled_A", 0, streams.IndexOf(indexStreamShapeA));
            ModelDataCreationUtility.AddShape(model, "shapeB", "matA", "boneCompressEnabled_B", 1, streams.IndexOf(indexStreamShapeB));

            IfRigidBodyToRigidSkinning.ConvertRigidBodyToRigidSkinning(model, streams);

            //
            // 以下のような結果になることをテスト
            //
            // boneRoot
            // |_boneCompressEnabled_E(compress_enable=true)
            //   |_boneCompressDisabled(compress_enable=false)
            //     |_shapeA
            //     |_shapeB
            //
            {
                var shape = model.shape_array.shape.FirstOrDefault(x => x.name == "shapeA");
                Assert.AreEqual(1, shape.shape_info.vertex_skinning_count);
                Assert.AreEqual("boneCompressDisabled", shape.shape_info.bone_name);

                var attrs = model.vertex_array.vertex[shape.shape_info.vertex_index].vtx_attrib_array.Items;
                Assert.AreEqual(2, attrs.Length);
                Assert.AreEqual("_p0", attrs[0].name);
                Assert.AreEqual("_i0", attrs[1].name);
            }

            {
                var shape = model.shape_array.shape.FirstOrDefault(x => x.name == "shapeB");
                Assert.AreEqual(1, shape.shape_info.vertex_skinning_count);
                Assert.AreEqual("boneCompressDisabled", shape.shape_info.bone_name);

                var attrs = model.vertex_array.vertex[shape.shape_info.vertex_index].vtx_attrib_array.Items;
                Assert.AreEqual(2, attrs.Length);
                Assert.AreEqual("_p0", attrs[0].name);
                Assert.AreEqual("_i0", attrs[1].name);
            }
        }
    }
}
