﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using System.Reflection;
using nw.g3d.toollib;
using nw.g3d.iflib;
using nw.g3d.nw4f_3dif;
using nw.g3d.iflib.nw3de;
using _3dToolsTestUtility;
using Nintendo.G3dTool.Entities;

namespace _3dIntermediateFileAssignUtilityTest
{
    /// <summary>
    /// assign-search-path のテストです。
    /// </summary>
    [TestClass]
    public class AssignShaderTest
    {
        [TestMethod]
        public void AssignShader()
        {
            G3dParallel.Job = 1;
            nw.g3d.ifassign.g3difassign tool = new nw.g3d.ifassign.g3difassign();
            var inputFile = System.IO.Path.Combine(IoUtility.GetG3dDemoRootPath(), "Resources/human/human.fmdb");
            nw.g3d.ifassign.g3difassign.XsdBasePath = G3dToolUtility.GetXsdBasePath();
            {
                string outputFmdFilePath = IoUtility.GetTempFilePath($"{System.IO.Path.GetFileNameWithoutExtension(inputFile)}.fmdb");
                try
                {
                    // -f をつけない場合のテスト
                    string shaderDefPath = "Resources/town.fsdb";
                    tool.Arguments = $"-j 1 assign {inputFile} --shader {shaderDefPath} --shading-model town -o {outputFmdFilePath}";
                    tool.Run();

                    // 出力後の fmdb が正しいかテスト
                    var file = IfReadUtility.ReadIntermediateFile(outputFmdFilePath, nw.g3d.ifassign.g3difassign.XsdBasePath);
                    var model = file.GetRootEntity<Model>();
                    Assert.AreEqual("demo", model.Materials[0].ShaderAssign.ShaderArchive);
                    Assert.AreEqual("basic", model.Materials[0].ShaderAssign.ShadingModel);
                }
                finally
                {
                    if (System.IO.File.Exists(outputFmdFilePath))
                    {
                        System.IO.File.Delete(outputFmdFilePath);
                    }
                }
            }

            {
                string outputFmdFilePath = IoUtility.GetTempFilePath($"{System.IO.Path.GetFileNameWithoutExtension(inputFile)}.fmdb");
                try
                {
                    // -f のテスト
                    string shaderDefPath = "Resources/town.fsdb";
                    tool.Arguments = $"-j 1 assign {inputFile} --shader {shaderDefPath} --shading-model town -f -o {outputFmdFilePath}";
                    tool.Run();

                    // 出力後の fmdb が正しいかテスト
                    var file = IfReadUtility.ReadIntermediateFile(outputFmdFilePath, nw.g3d.ifassign.g3difassign.XsdBasePath);
                    var model = file.GetRootEntity<Model>();
                    Assert.AreEqual("town", model.Materials[0].ShaderAssign.ShaderArchive);
                    Assert.AreEqual("town", model.Materials[0].ShaderAssign.ShadingModel);
                }
                finally
                {
                    if (System.IO.File.Exists(outputFmdFilePath))
                    {
                        System.IO.File.Delete(outputFmdFilePath);
                    }
                }
            }
        }
    }
}
