﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.G3dTool.Entities;
using nw.g3d.nw4f_3dif;

namespace G3dLibraryTest
{
    [TestClass]
    public class VertexTest
    {
        [TestMethod]
        public void VtxAttribTest()
        {
            var vertex = new Vertex();
            VtxAttrib attr = new VtxAttrib();
            attr.Type = vtx_attrib_typeType.int4;
            vertex.VtxAttribs.Add(attr);

            StreamInt stream = new StreamInt();
            stream.Values.Add(new int[] { 0, 0, 0, 0, 0, 0, 0, 0});
            attr.Stream = stream;

            Model model = new Model();
            model.Vertexes.Add(vertex);
            model.Streams.Add(stream);

            Assert.AreEqual(2, attr.Count);
        }
    }
}
