﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.G3dTool.Entities;
using nw.g3d.nw4f_3dif;
using System.Linq;
using nw.g3d.iflib;
using _3dToolsTestUtility;
using System.Reflection;
using System.IO;

namespace G3dLibraryTest
{
    [TestClass]
    public class SkeletalAnimTest
    {
        [TestMethod]
        public void SkeletalAnimStreamReferenceTest()
        {
            var sourceFile = new IntermediateFile(IntermediateFileKind.SkeletalAnim);
            var skeletalAnim = sourceFile.GetRootEntity<SkeletalAnim>();
            var boneAnim = new BoneAnim();
            skeletalAnim.BoneAnims.Add(boneAnim);
            Assert.IsNotNull(boneAnim.Parent);

            bone_anim_target_targetType testTargetKey = bone_anim_target_targetType.translate_x;
            var target = boneAnim.BoneAnimTargets[testTargetKey];
            Assert.IsNotNull(target.Parent);

            var curve = new LinearCurve();
            target.Curve = curve;
            Assert.IsNotNull(curve.Parent);

            StreamFloat dummyStream = new StreamFloat();
            StreamFloat stream = new StreamFloat();
            curve.Stream = stream;

            skeletalAnim.Streams.Add(dummyStream);
            skeletalAnim.Streams.Add(stream);
            skeletalAnim.SkeletalAnimInfo.RotateMode = skeletal_anim_info_rotate_modeType.euler_xyz;

            var writeData = sourceFile.CreateSerializableData();
            Assert.AreEqual(9, (writeData.Item as skeletal_animType).bone_anim_array.Items[0].bone_anim_target.Length);
            Assert.AreEqual(1, (writeData.Item as skeletal_animType).bone_anim_array.Items[0].bone_anim_target.First(x => x.target == testTargetKey).Curve.stream_index);

            // 再度データモデル構築後にストリームの参照が作られるかをチェック
            var file = new IntermediateFile(writeData);
            Assert.IsNotNull(file.GetRootEntity<SkeletalAnim>().BoneAnims[0].BoneAnimTargets[testTargetKey].Curve.Stream);
        }

        [TestMethod]
        public void BoneAnimUserDataTest()
        {
            var file = new IntermediateFile(IntermediateFileKind.SkeletalAnim);
            var sklAnim = file.GetRootEntity<SkeletalAnim>();
            var boneAnim = new BoneAnim()
            {
                Name = "boneA"
            };
            sklAnim.BoneAnims.Add(boneAnim);

            var userData = new UserDataFloat()
            {
                Name = "userDataA"
            };
            userData.Values.Add(0.1f);
            boneAnim.UserDatas.Add(userData);

            string filePath = IoUtility.GetTempFilePath(MethodBase.GetCurrentMethod().Name + ".fskb");
            try
            {
                IfWriteUtility.WriteIntermediateFile(file, filePath, IoUtility.GetXsdBasePath());
            }
            finally
            {
                if (File.Exists(filePath))
                {
                    File.Delete(filePath);
                }
            }
        }
    }
}
