﻿#include "edittest_common.glsl"
#include "edittest_material.glsl"

#ifdef NW_FRAGMENT_SHADER

void main()
{
    vec4 outColor = vec4(0.0, 0.0, 0.0, 1.0);

    if (nw_int_to_bool(USE_HEMISPHERE_LIGHT))
    {
        float costheta = dot(v_normal, -hemiDir.xyz);
        float a = costheta * 0.5 + 0.5;
        outColor.xyz = mix(skyColor.xyz, groundColor.xyz, a) * ambient;
    }

    if (nw_int_to_bool(USE_DIRECTIONAL_LIGHT))
    {
        float costheta = dot(v_normal, lightDir.xyz);
        outColor.xyz += diffuse.xyz * diffuseColor.xyz * costheta;
    }

    vec2 texcoord = vec2(v_texcoord.x * tex_sr_v0 + (v_texcoord.y * tex_sr_v1 + tex_translate));
    vec4 texColor = texture(albedoTex0, texcoord);
    outColor *= texColor;

    if (nw_int_to_bool(USE_FOG))
    {
        float interpolation = clamp((-v_viewPos.z) * fogStartEndInv + fogStart, 0.0, 1.0);
        outColor.rgb += fogColor.rgb * interpolation;
    }

    outColor.rgb = factor FACTOR_FUNCTION outColor.rgb;
    gl_FragColor = outColor;
}

#endif
