﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <g3ddemo_DemoUtility.h>

#define DEFINE_MENU(title) { #title, strlen(#title), title##Main }

//--------------------------------------------------------------------------------------------------

int DataEditMain(int argc, const char* argv[]);
int EditThreadMain(int argc, const char* argv[]);
int NnG3dViewerCommunicationMain(int argc, const char* argv[]);

nw::g3d::demo::CmdMenu::Item s_MenuItems[] = {
    DEFINE_MENU(DataEdit),
    DEFINE_MENU(EditThread),
#if PLATFORM != CAFE
    DEFINE_MENU(NnG3dViewerCommunication),
#endif
    { "Exit", strlen("Exit"), NULL }
};

int main(int argc, const char* argv[])
{
    nw::g3d::demo::InitLauncher();

    --argc;
    ++argv;

    nw::g3d::DebugPrint("[g3d sandbox launcher]\n");
    nw::g3d::demo::CmdMenu menu(s_MenuItems);
    return menu.Loop(argc, argv);
}
