﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace G3dHioTestTool
{
    public class Texture :
        NintendoWare.G3d.Edit.IEditTextureTarget
    {
        /// <summary>
        /// ターゲットを特定するためのキーを取得します。
        /// </summary>
        public uint Key { get; set; }

        /// <summary>
        /// 編集対象のResFileを特定するキーを取得します。
        /// </summary>
        public uint ResFileKey { get; set; }

        /// <summary>
        /// ターゲットがアタッチされているか状態かを判定します。
        /// </summary>
        public bool IsAttached { get; set; }

        /// <summary>
        /// ターゲットが削除されている状態かを判定します。
        /// </summary>
        public bool IsDeleted { get; set; }

        /// <summary>
        /// ランタイムで使用する情報をリセットします。
        /// </summary>
        public void ResetStatus()
        {
            this.ResFileKey = 0;
        }
    }
}
