﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.G3d.Edit;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace G3dHioTestTool
{
    enum AnimKind
    {
        SkeletalAnim,
        MaterialAnim
    };

    internal class Animation : IEditTarget
    {
        /// <summary>
        /// 編集対象のResModelを特定するキーを取得します。
        /// </summary>
        public uint ResModelKey { get; set; }

        /// <summary>
        /// 編集対象のModelObjを特定するキーを取得します。
        /// </summary>
        public uint ModelObjKey { get; set; }

        /// <summary>
        /// アタッチから実行されたモデルか判定します。
        /// </summary>
        public bool IsSendAttached { get; set; }

        /// <summary>
        /// ターゲットを特定するためのキーを取得します。
        /// </summary>
        public uint Key { get; set; }

        /// <summary>
        /// 編集対象のResFileを特定するキーを取得します。
        /// </summary>
        public uint ResFileKey { get; set; }

        /// <summary>
        /// ターゲットがアタッチされているか状態かを判定します。
        /// </summary>
        public bool IsAttached { get; set; }

        /// <summary>
        /// ターゲットが削除されている状態かを判定します。
        /// </summary>
        public bool IsDeleted { get; set; }

        /// <summary>
        /// ランタイムで使用する情報をリセットします。
        /// </summary>
        public void ResetStatus()
        {
            this.ResFileKey = 0;
        }

        public AnimKind AnimKind
        {
            get;
            set;
        }
    }
}
