﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/gtest/gtest.h>
#include <nnt/result/testResult_Assert.h>

#include "../../../../../Programs/Eris/Sources/Drivers/tmp451/detail/tmp451_InitializeFinalize.h"
#include "../../../../../Programs/Eris/Sources/Drivers/tmp451/detail/tmp451_InternalFunction.h"

namespace nnt { namespace tmp451 {

// 省電力モード (shutdown mode) でないことを確認するテスト
// tmp451 のレジスタの値を調べたいので、nnd::tmp451::detail 以下の関数を直接呼ぶ
TEST(PowerState, IsNotShutdownMode)
{
    using namespace nnd::tmp451;

    detail::BusSessions bus;
    detail::Initialize(&bus);

    detail::ConfigReg config;
    detail::ReadConfig(&config, bus);

    EXPECT_FALSE(config.isShutdown);

    detail::Finalize(&bus);
}

}}
