﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/time/time_Api.h>
#include "testTime_TimeZoneTestUtil.h"


int GetDayOfSpecific(int year, int month, GettingWeekType type, nn::time::DayOfWeek dayOfWeek) NN_NOEXCEPT
{
    int startDay = 0;

    if(type == GettingWeekType ::First)
    {
        startDay = 1;
    }
    else if(type == GettingWeekType::Second)
    {
        startDay = 8;
    }
    else if(type == GettingWeekType::Last)
    {
        startDay = nn::time::GetDaysInMonth(year, month) - 6;
    }
    else
    {
        NN_ABORT("[TIME TEST] Invalid GettingWeekType at GetDayOfSpecific");
    }

    const int endDay = startDay + 6;

    for(int day = startDay ; day <= endDay ; ++day)
    {
        if(nn::time::GetDayOfWeek(year, month, day) == dayOfWeek)
        {
            return day;
        }
    }
    NN_ABORT("[TIME TEST] A specific day was not found at GetDayOfSpecific");
    return 1;
}

