﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>


#include <nn/time/time_Api.h>
#include <nn/time/time_ApiForSystem.h>

//
// time:s だけもっているテストプログラム
//


TEST(TimeOnlyAdminCapability, Initialize)
{
    auto result = nn::time::Initialize();
#if NN_BUILD_CONFIG_OS_WIN
    EXPECT_TRUE(result.IsSuccess()); // win だと権限チェックないので成功してしまう
#else
    EXPECT_TRUE(result.IsFailure());
#endif
    if(result.IsSuccess())
    {
        NNT_EXPECT_RESULT_SUCCESS( nn::time::Finalize() );
    }
}

TEST(TimeOnlyAdminCapability, InitializeForSystem)
{
    NNT_ASSERT_RESULT_SUCCESS( nn::time::InitializeForSystem() );
    NNT_ASSERT_RESULT_SUCCESS( nn::time::Finalize() );
}

