﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_SdkText.h>
#include <nn/nn_Log.h>
#include <nn/os/os_MemoryHeap.h>
#include <nn/os/os_Result.h>
#include <nn/os/os_Event.h>
#include <nn/tics/tics_Api.h>

#include "CrossBar.h"
#include "TCPSlot.h"

#include "testHtc_EchoPlug.h"

/*
    libnn_htc.lib を利用して実装されたエコーサーバ。Mux は使用しない。
    1つのクライアントと通信した後、通信が切れるとプログラムも終了する。
*/

extern "C" void nninitStartup()
{
}

extern "C" void nnMain()
{
    // メモリヒープ確保
    NN_LOG("*** nn::os::SetMemoryHeapSize()\n");
    size_t heapSize = 16 * 1024 * 1024; // 16MB
    nn::Result result = nn::os::SetMemoryHeapSize( heapSize );
    NN_ABORT_UNLESS( result.IsSuccess(), NN_TEXT("メモリヒープの確保に失敗しました。") );

    uintptr_t heapAddress;
    result = nn::os::AllocateMemoryBlock( &heapAddress, heapSize );
    NN_ABORT_UNLESS( result.IsSuccess(), NN_TEXT("メモリヒープの確保に失敗しました。") );

    NN_LOG("*** nn::tics::Initialize()\n");
    nn::tics::Initialize( heapAddress, heapSize );

    NN_LOG("*** ::tics::portability::stl::string()\n");
    const ::tics::portability::stl::string echoServerSessionName("echoserver");
    const ::tics::portability::stl::string echoServerSlotId("tcp");
    const ::tics::portability::stl::string echoServerPort("6003");

    // Slot を1つだけ持つ CrossBar を作成
    NN_LOG("*** new ::tics::CrossBar()\n");
    ::tics::CrossBar* pCrossBar = new ::tics::CrossBar();

    NN_LOG("*** ::tics::TcpSlot()\n");
    /* 第3引数 intType を空欄にして、サーバモードに。第4引数 host を空欄にして、任意のアドレスから接続を受け付け。 */
    ::tics::TCPSlot* pTcpSlot = new ::tics::TCPSlot(echoServerSlotId, "", "", echoServerPort);

    NN_LOG("*** ::tics::CrossBar::AddSlot()\n");
    pCrossBar->AddSlot(echoServerSessionName, pTcpSlot);

    // プラグを登録して、処理開始
    NN_LOG("*** EchoPlug()\n");
    ::EchoPlug* pEchoPlug = new ::EchoPlug();
    NN_LOG("*** ::tics::CrossBar::RegisterForSessionStart()\n");
    pCrossBar->RegisterForSessionStart(echoServerSessionName, pEchoPlug);
    NN_LOG("*** ::tics::CrossBar::Run()\n");
    pCrossBar->Run();
    delete pCrossBar;

    NN_LOG("*** nn::tics::Finalize()\n");
    nn::tics::Finalize();

    NN_LOG("*** Finish!\n");
}
