﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>

#include "TicsCfg.h"
#include "Plug.h"
#include "CrossBar.h"
#include "RawMemBuffer.h"
#include "TicsMsg.h"

#include "testHtc_EchoPlug.h"

/*
    グローバル定数
*/
namespace {
    const size_t BufferSize = 2048;
}

void EchoPlug::OnSessionStarted (::tics::portability::stl::string type, ::tics::Endpoint* connectedEP)
{
    SetType(type);
    SetEndpoint(connectedEP);
    SetCrossBar( connectedEP->GetCrossBar() );


    NN_LOG("---- EchoPlug::OnSessionStarted ----\n");

    // 送受信バッファの確保と初期化
    m_Buffer = new tics::RawMemBuffer( BufferSize );

    // データ受信開始
    this->BeginReceive(1, BufferSize, m_Buffer);
}

int EchoPlug::OnReceiveComplete(::tics::Buffer* buffer, long offset, long len)
{
    NN_UNUSED( buffer );
    NN_UNUSED( offset );
    NN_UNUSED( len );

    NN_LOG("---- EchoPlug::OnReceiveComplete ----\n");

    // データ送信開始
    this->BeginSend(m_Buffer, 0, len, true);

    return 0;
}

int EchoPlug::OnSendComplete(::tics::Buffer* buffer, long offset, long len)
{
    NN_UNUSED( buffer );
    NN_UNUSED( offset );
    NN_UNUSED( len );

    NN_LOG("---- EchoPlug::OnSendComplete ----\n");

    // データ受信再開
    this->BeginReceive(1, BufferSize, m_Buffer);

    return 0;
}

int EchoPlug::OnDetach()
{
    NN_LOG("---- EchoPlug::OnDetach ----\n");

    SetCrossBar( NULL );

    return 0;
}

int EchoPlug::OnRemoteDetach()
{
    NN_LOG("---- EchoPlug::OnRemoteDetach ----\n");

    SetCrossBar( NULL );

    return 0;
}
