﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Thread.h>
#include "CrossBar.h"

/*
@brief
    CrossBar::Run() を別スレッドで呼ぶための一連の処理を行う。
*/
class CrossBarRunThread
{
public:
    explicit CrossBarRunThread( ::tics::CrossBar* pCrossBar );
    ~CrossBarRunThread();

    inline void StartThread()
    {
        nn::os::StartThread( &m_Thread );
    }

    inline void WaitThread()
    {
        nn::os::WaitThread( &m_Thread );
    }

private:
    nn::os::ThreadType m_Thread;
    ::tics::CrossBar* m_pCrossBar;
    void* m_Stack;
};
