﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>

#include <nn/nn_Log.h>
#include <nn/os/os_Event.h>
#include "Plug.h"
#include "CrossBar.h"
#include "RawMemBuffer.h"

#include <cstring>

#include "testHtc_EchoClientPlug.h"

void EchoClientPlug::OnSessionStarted (::tics::portability::stl::string type, ::tics::Endpoint* connectedEP)
{
    SetType(type);
    SetEndpoint(connectedEP);

    NN_LOG("---- EchoClientPlug::OnSessionStarted ----\n");

    // 送信バッファの確保と初期化
    m_SendBuffer = new tics::RawMemBuffer( m_DataSize );
    m_SendBuffer->CopyFrom(m_pData, m_DataSize);

    // データを送信
    this->BeginSend(m_SendBuffer, 0, m_DataSize, true);
}

int EchoClientPlug::OnSendComplete(::tics::Buffer* buffer, long offset, long len)
{
    NN_UNUSED( buffer );
    NN_UNUSED( offset );
    NN_UNUSED( len );

    NN_LOG("---- EchoClientPlug::OnSendComplete ----\n");

    // 受信バッファの確保と初期化
    m_RecvBuffer = new tics::RawMemBuffer( m_DataSize );

    // データの受信を待つ
    this->BeginReceive(m_DataSize, m_DataSize, m_RecvBuffer, 0);

    return 0;
}

int EchoClientPlug::OnReceiveComplete(::tics::Buffer* buffer, long offset, long len)
{
    NN_UNUSED( buffer );
    NN_UNUSED( offset );
    NN_UNUSED( len );

    NN_LOG("---- EchoClientPlug::OnReceiveComplete ----\n");

    // 処理の終了を示すイベントをシグナル状態にする
    if ( m_pEvent != nullptr )
    {
        nn::os::SignalEvent( m_pEvent );
    }

    return 0;
}

int EchoClientPlug::OnDetach()
{
    return 0;
}

int EchoClientPlug::OnRemoteDetach()
{
    return 0;
}

const void* EchoClientPlug::GetRecvData()
{
    return m_RecvBuffer->m_Payload;
}

void EchoClientPlug::SetSendData( const void* pData, size_t dataSize )
{
    m_pData = pData;
    m_DataSize = dataSize;
}
