﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>

#include <nn/nn_ErrorResult.h>

namespace nnt { namespace testtest {

    NN_DEFINE_ERROR_RANGE_RESULT(ResultA, 401, 100, 101);
    NN_DEFINE_ERROR_RANGE_RESULT(ResultB, 401, 200, 300);
    NN_DEFINE_ERROR_RANGE_RESULT(ResultC, 401, 201, 202);

}}

/**
    nnt::result::detail::IsResultSuccess() のテストです。
    引数の nn::Result が成功のケースです。
*/
TEST(testResult, success)
{
    EXPECT_TRUE(nnt::result::detail::IsResultSuccess("nn::ResultSuccess()", nn::ResultSuccess()));
}

/**
    nnt::result::detail::IsResultSuccess() のテストです。
    引数の nn::Result が失敗のケースです。
*/
TEST(testResult, failure)
{
    ::testing::AssertionResult assertionResult =
        nnt::result::detail::IsResultSuccess("nnt::testtest::ResultA()", nnt::testtest::ResultA());

    EXPECT_FALSE(assertionResult);

    const char * expectedMessage = "\nValue of: nnt::testtest::ResultA()\n  Actual: UnknownResult(0x0000c991, module=401, desc=100)\nExpected: nn::ResultSuccess(0x00000000, module=0, desc=0)";
    ASSERT_STREQ(expectedMessage, assertionResult.message());
}

/**
    nnt::result::detail::IncludeResult() のテストです。
    result が expectedResult に含まれるケースです。
*/
TEST(testResult, included)
{
    EXPECT_TRUE(
        nnt::result::detail::IncludeResult<nnt::testtest::ResultB>(
            "nnt::testtest::ResultB()", "nnt::testtest::ResultC()",
            nnt::testtest::ResultB(), nnt::testtest::ResultC()));
}

/**
    nnt::result::detail::IncludeResult() のテストです。
    result が expectedResult に含まれないケースです。
*/
TEST(testResult, notIncluded)
{
    ::testing::AssertionResult assertionResult =
        nnt::result::detail::IncludeResult<nnt::testtest::ResultB>(
            "nnt::testtest::ResultB()", "nnt::testtest::ResultA()",
            nnt::testtest::ResultB(), nnt::testtest::ResultA());

    EXPECT_FALSE(assertionResult);

    const char * expectedMessage = "\nValue of: nnt::testtest::ResultA()\n  Actual: UnknownResult(0x0000c991, module=401, desc=100)\nExpected: UnknownResult(0x00019191, module=401, desc=200)";
    ASSERT_STREQ(expectedMessage, assertionResult.message());
}
