﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>

#include "abuse_ui_MenuEntryView.h"
#include "abuse_ui_ContentView.h"
#include "abuse_ui_Notifier.h"

namespace nnt {
namespace abuse {

class MenuView : public glv::View
{
    NN_DISALLOW_COPY( MenuView );
    NN_DISALLOW_MOVE( MenuView );

public:
    MenuView(const unsigned width, const unsigned height) NN_NOEXCEPT;

    ~MenuView() NN_NOEXCEPT;

    virtual const char *className() const { return "MenuView"; };

    virtual void onAnimate(double dsec) NN_NOEXCEPT;

    void AttachContent(ContentView& content);
    void Hit(MenuEntryView *pEntry);

private:
    glv::Placer        m_Placer;
    glv::space_t       m_Speed;
    glv::Style         m_Style;

private:
    void AddEntry(glv::View *pView);
    static void Show(const glv::Notification& n);
    static void Hide(const glv::Notification& n);
};

} // ~abuse
} // ~nnt
