﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>

#include "abuse_ui_PageView.h"

namespace nnt {
namespace abuse {

class MenuEntryView : public glv::View
{
public:
    MenuEntryView(const unsigned width, const unsigned height,
                  PageView& page) NN_NOEXCEPT;

    ~MenuEntryView() NN_NOEXCEPT;

    virtual const char *className() const { return "MenuEntryView"; };

    virtual bool onEvent(glv::Event::t e, glv::GLV& g) NN_NOEXCEPT;

    void Hit();
    void Reset();

private:
    glv::Label   m_Title;
    PageView&    m_Page;
    glv::Style   m_Style;
};

} // ~abuse
} // ~nnt
