﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <algorithm>

#include "abuse_ui_Theme.h"
#include "abuse_ui_HomeView.h"


namespace nnt {
namespace abuse {


// home page view
HomeView::HomeView(ContentView& content) NN_NOEXCEPT
    : PageView(content, "Home")
    , m_Message("Home Page")
    , m_ShowDetail(false)
{
    enable(glv::Property::CropChildren);

    *this << m_Message;

    // enable state message by default
    m_Message.enable(glv::Property::Visible);
    m_Message.size(NoticeFontSize);
    m_Message.pos(glv::Place::CC, width() / 2, height() / 2);

    HideDetail();
}

HomeView::~HomeView() NN_NOEXCEPT
{
}

void HomeView::onAnimate(double dsec)
{

}

void HomeView::ShowDetail() NN_NOEXCEPT
{
}

void HomeView::HideDetail() NN_NOEXCEPT
{
}

void HomeView::OnDataRoleChange(const glv::Notification& n) NN_NOEXCEPT
{
}

void HomeView::OnDeviceUpdate(const glv::Notification& n) NN_NOEXCEPT
{
}

void HomeView::OnShowDetail(const glv::Notification& n) NN_NOEXCEPT
{
    HomeView *self = n.receiver<HomeView>();

    self->enable(glv::Property::Animate);

    self->m_ShowDetail = true;
}

void HomeView::OnHideDetail(const glv::Notification& n) NN_NOEXCEPT
{
    HomeView *self = n.receiver<HomeView>();

    self->enable(glv::Property::Animate);

    self->m_ShowDetail = false;
}

} // ~abuse
} // ~nnt
