﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>
#include "abuse_ui_HeartBeatView.h"


namespace nnt {
namespace abuse {

class FooterView : public glv::View
{
    NN_DISALLOW_COPY( FooterView );
    NN_DISALLOW_MOVE( FooterView );

public:
    FooterView(const unsigned width, const unsigned height) NN_NOEXCEPT;

    ~FooterView() NN_NOEXCEPT;

    virtual const char *className() const { return "FooterView"; };

    virtual bool onEvent(glv::Event::t e, glv::GLV& g) NN_NOEXCEPT;

private:
    glv::Label    m_MenuModeLabel;
    HeartBeatView m_HeartBeat;

    void UpdateLabel() NN_NOEXCEPT;
};

} // ~abuse
} // ~nnt
