﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/util/util_FormatString.h>

#include "abuse_ui_Theme.h"
#include "abuse_ui_Notifier.h"
#include "abuse_ui_FooterView.h"

namespace nnt {
namespace abuse {


// footer view
FooterView::FooterView(const unsigned width, const unsigned height) NN_NOEXCEPT
    : glv::View(glv::Rect(width, height))
    , m_MenuModeLabel("Menu                                                                                                                                                                      Status: ")
    , m_HeartBeat(height - FooterPaddingY * 2)
{
    enable(glv::Property::HitTest);

    // heart beat box to indicate whether the app is active or not
    m_HeartBeat.pos(glv::Place::TR,
        glv::Rect::width() - FooterPaddingX,
        FooterPaddingY);

    *this << m_HeartBeat << m_MenuModeLabel;

    // enable footer message by default
    m_MenuModeLabel.size(NormalFontSize);
    m_MenuModeLabel.pos(glv::Place::TL, FooterPaddingX, FooterPaddingY);
    m_MenuModeLabel.enable(glv::Property::Visible | glv::Property::FocusToTop);
}

FooterView::~FooterView() NN_NOEXCEPT
{
}


bool FooterView::onEvent(glv::Event::t e, glv::GLV& g) NN_NOEXCEPT
{
    if (e == glv::Event::MouseDown)
    {
        g_Notifier.notify(Event_ShowMenu, nullptr);
        return false;
    }
    else
    {
        return true;
    }
}


} // ~abuse
} // ~nnt
