﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "Tasks/CurlStressTask.h"
#include <cstring>
#include <nn/os.h>
#include <nn/os/os_Event.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>



namespace
{
    NN_ALIGNAS(4096) uint8_t g_SocketMemoryPoolBuffer[nn::socket::DefaultSocketMemoryPoolSize];
}

namespace nnt
{
    namespace abuse
    {

        CurlStressTask::CurlStressTask(const String& typeName, const String& instanceName)
            : BaseTask(typeName, instanceName)
        {
        }
        CurlStressTask::~CurlStressTask()
        {
        }

        InitStatus CurlStressTask::Initialize(const String& params)
        {
            nn::socket::Initialize(reinterpret_cast<void*>(g_SocketMemoryPoolBuffer),
                                   nn::socket::DefaultSocketMemoryPoolSize,
                                   nn::socket::DefaultSocketAllocatorSize,
                                   nn::socket::DefaultConcurrencyLimit);
            m_receiveBuffer = (char *)Platform::Allocate(CURL_MAX_WRITE_SIZE);
            curl_global_init_mem(CURL_GLOBAL_DEFAULT, Platform::Allocate, Platform::Free,Platform::Reallocate, Platform::StringDuplicate, Platform::ClearAllocate);

            m_curlMultiHandle = curl_multi_init();
            if (!m_curlMultiHandle)
            {
                LogError("curl_multi_init() FAILED\n");
                return INIT_ERROR;
            }



            return INIT_OK;
        }

        StartStatus CurlStressTask::Start()
        {
            return START_OK;
        }

        RunStatus CurlStressTask::Run()
        {

            /* Perform the request, res will get the return code */
            CURLcode res = CURLE_OK;// = curl_multi_perform(m_curlMultiHandle);

            /* Check for errors */
            if (res != CURLE_OK)
            {
                LogError("\nCURL_EASY_PERFORM() FAILED\n");
                return RUN_ERROR;
            }

            return RUN_KILL;
        }
        StopStatus CurlStressTask::Stop()
        {
            return STOP_OK;
        }

        ShutdownStatus CurlStressTask::Shutdown()
        {
            /* always cleanup */
            if(m_curlMultiHandle)
            {
                curl_multi_cleanup(m_curlMultiHandle);
            }
            if(m_receiveBuffer)
            {
                Platform::Free(m_receiveBuffer);
            }

            return SHUTDOWN_OK;
        }

        size_t CurlStressTask::CurlEasyContainer::ReadCallback(char *buffer, size_t size, size_t nitems, void *instream)
        {
            return 0;
        }
        size_t CurlStressTask::CurlEasyContainer::WriteCallback(char *ptr, size_t size, size_t nmemb, void *userdata)
        {
            CurlEasyContainer * easyContainer = (CurlEasyContainer * )userdata;

            if(size*nmemb > CURL_MAX_WRITE_SIZE)
            {
                easyContainer->parent->LogError("Received Data Larger Than CURL_MAX_WRITE_SIZE! CURL_MAX_WRITE_SIZE:%d Received Data Size:",CURL_MAX_WRITE_SIZE,size*nmemb);
                return 0;
            }
            memcpy(easyContainer->m_receiveBuffer,ptr,nmemb*size);
            easyContainer->receivedData = true;
            return nmemb*size;
        }

        CurlStressTask::CurlEasyContainer::CurlEasyContainer():
            m_curlEasyHandle(nullptr)
        {
            m_curlEasyHandle = curl_easy_init();

            /* currently using host resolver for DNS resolution */
            curl_easy_setopt(m_curlEasyHandle, CURLOPT_URL, "http://www.example.com");

            /* optionally set verbose for debugging */
           // curl_easy_setopt(m_curl, CURLOPT_VERBOSE, 1L);

            curl_easy_setopt(m_curlEasyHandle,CURLOPT_WRITEFUNCTION,WriteCallback);
            curl_easy_setopt(m_curlEasyHandle,CURLOPT_WRITEDATA,this);

            curl_easy_setopt(m_curlEasyHandle,CURLOPT_READFUNCTION,ReadCallback);
            curl_easy_setopt(m_curlEasyHandle,CURLOPT_READDATA,this);
        }
        CurlStressTask::CurlEasyContainer::~CurlEasyContainer()
        {
            if(m_curlEasyHandle)
            {
                curl_easy_cleanup(m_curlEasyHandle);
            }
        }

        CURLMcode CurlStressTask::CurlEasyContainer::CurlEasyRegister(CURLM * multiHandle)
        {

            return curl_multi_add_handle(multiHandle,m_curlEasyHandle);
        }
        CURLMcode CurlStressTask::CurlEasyContainer::CurlEasyUnregister(CURLM * multiHandle)
        {

            return curl_multi_remove_handle(multiHandle,m_curlEasyHandle);
        }
    }
}
