﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <Tasks/BaseTask.h>
namespace nnt
{
    namespace abuse
    {
        class OsTlsTask;
        struct TlsThreadArg
        {
            OsTlsTask* task;
            int threadId;
            nn::os::TlsSlot tlsSlot;
            bool tlsDestroyed;
            bool tlsSet;
        };

        class OsTlsTask : public BaseTask
        {
        public:
            OsTlsTask(const String& typeName, const String& instanceName);
            virtual ~OsTlsTask();

            virtual InitStatus Initialize(const String& params);
            virtual StartStatus Start();
            virtual RunStatus Run();
            virtual StopStatus Stop();
            virtual ShutdownStatus Shutdown();

            virtual const char* GetParamOptions();
        private:
            static void workerFunc(void* arg);
            static void tlsCheck(nn::os::TlsSlot tls);
            static void tlsDestructor(uintptr_t value);

            TlsThreadArg*        m_threadArgs;
            nn::os::ThreadType*  m_threads;
            void**               m_stacks;
            nn::os::TlsSlot      m_TlsSlots[16];
            int                  m_maxThreads;
            int                  m_maxGroups;
            int                  m_numGroups;
            int                  m_numThreads;
            int                  m_numActualThreads;
            int                  m_priority;
        };
    }
}
