﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <cstdlib>
#include <string>
#include <nn/nifm.h>
#include <nn/nifm/nifm_NetworkConnection.h>
#include <nn/nifm/nifm_ApiRequest.h>
#include <nn/nifm/nifm_ApiClientManagement.h>
#include <nn/nifm/nifm_ApiForTest.h>
#include <nn/os.h>
#include <nn/socket.h>
#include <nn/ssl.h>
#include <curl/curl.h>
#include "BaseTask.h"
#include "../HelperFunctions/HttpsHelper.h"

namespace nnt
{
    namespace abuse
    {
        const float kGigabyte = 1024.0f * 1024.0f * 1024.0f;
        const float kMegabyte = 1024.0f * 1024.0f;
        const float kKilobyte = 1024.0f;
        const int   kMaxUrlLength = 512;

        // urls for the test server
        static const char TEST_ROOT_CA_CERT[] = "-----BEGIN CERTIFICATE-----\nMIIEJjCCAw6gAwIBAgICAQAwDQYJKoZIhvcNAQEFBQAwgZsxCzAJBgNVBAYTAlVT\nMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMQwwCgYDVQQK\nEwNOT0ExDDAKBgNVBAsTA05URDEfMB0GA1UEAxMWTlREIGxpYmN1cmwgVGVzdGlu\nZyBDQTEoMCYGCSqGSIb3DQEJARYZc2hhd21vMDNAbnRkLm5pbnRlbmRvLmNvbTAe\nFw0xNjEyMDEwMDAwMDBaFw0yNjEyMDEwMDAwMDBaMIGbMQswCQYDVQQGEwJVUzET\nMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEMMAoGA1UEChMD\nTk9BMQwwCgYDVQQLEwNOVEQxHzAdBgNVBAMTFk5URCBsaWJjdXJsIFRlc3Rpbmcg\nQ0ExKDAmBgkqhkiG9w0BCQEWGXNoYXdtbzAzQG50ZC5uaW50ZW5kby5jb20wggEi\nMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCsrFdrEOcBbeYNxoc4MEmJofHY\nzDGspQ8r1ZS4xwc8GzzBrAJ3qEhZDsqUHuQN+YxBdS2uNdrDqR+of1S54hbZozyp\nspkaFykbqkQZ2g3vu3gxXqg4WApXRRaVkFpXO4Nk5yznu+xhPO95L9eVEJpuULa7\nbbafxSEIVEOiy4XGUioQnHSpthpbbO1G+1XM+DAhgizi7xgGrpVbnRd98PeRNcRZ\nOJNWZHyZu3Y5neA+SZhbsGgcW+2XERtdJH65TRP7keVsUo+HPeegJmIbcLtt04hC\n1WN20en9WtlNGsnMnT7W6s/i9MDgjdughjybwkhnT2Mr3V9tQ5ivPJ0yCfClAgMB\nAAGjcjBwMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFBTnyeqRw4P/yTzxjtzI\n7AEyV4j4MAsGA1UdDwQEAwIBBjARBglghkgBhvhCAQEEBAMCAAcwHgYJYIZIAYb4\nQgENBBEWD3hjYSBjZXJ0aWZpY2F0ZTANBgkqhkiG9w0BAQUFAAOCAQEAArqnrIXW\nFYM4o07Mni/kMp70QMDnBogE24XagYaESyJp1YiBrZ2YZjWrjCV0GGKPyQsx0/H9\n2CLsLR61BjblgJt3eGb+YOfiOB6zIxxbqYNS0QR0I11XFv70Ld9RpcTTwCfOMtXr\nQ9s+Xuz8BKSFWPtRg6Dk4bjw6urYWpJzEa7ndBVdb58HLUZyVCNuqQF+hqr8eLFB\nPpBdUIurh9r/GWdB8SyuA6lBJBQoAEp76HIjX7SGJnCXjox8TIR3gbcYV4Sisa4r\nVdbfx8lO6IAXzsHwl+aj1WV8UbyTCVbNK7Ctonx7BNdYhJIWYT7sNg7C4/yDwP/x\nqphrhqLCw3d15A==\n-----END CERTIFICATE-----";

        // upload file info
        static const char UPLOAD_NAME[] = "imagefile";
        static const char UPLOAD_FILENAME[] = "foo.zip";
        static const char UPLOAD_CONTENTTYPE[] = "application/octet-stream";

        // jitter constant values
        static const int MIN_JITTER = 10000;   // 10000 bytes/sec download or upload
        static const int MAX_JITTER = 10;     // 10 bytes/sec download or upload
        static const int STEP_JITTER = 150;   // used to cycle to next jitter value

        enum InputParamType
        {
            INPUT_NONE = 0,
            UPLOAD,
            DOWNLOAD,
            JITTER
        };

        enum JitterParamType
        {
            JITTER_NONE = 0,
            RANDOM,
            CYCLE
        };

        typedef struct EasyData
        {
            CURL* easyHandle;
            char pErrorBuffer[CURL_ERROR_SIZE];
        } EasyData;

        typedef struct NetworkOptions
        {
            uint32_t    numConnections;
            uint32_t    timesToUploadOrDownload;
            int         sndBufSize;
            int         rcvBufSize;
            int         disableTcpNagle;
            int         uploadSize;
            std::string url;
        } Options;

        typedef struct WriteData {
            const char  *pReadPos;
            size_t      sizeLeft;
        } WriteData;


        class NetworkTransferTask : public BaseTask
        {
        public:
            NetworkTransferTask(const String& typeName, const String& instanceName);
            virtual ~NetworkTransferTask();

            virtual InitStatus Initialize(const String& params);
            virtual StartStatus Start();
            virtual RunStatus Run();
            virtual StopStatus Stop();
            virtual ShutdownStatus Shutdown();
            virtual const char* GetParamOptions();

        private:
            bool ProcessParams(const String& params);
            bool AssignParamValues(std::string currentToken);
            bool InitializeNetworkSettings();
            static size_t CurlWriteFunction(char *data, size_t blobsize, size_t blobcount, void *userdata);
            static size_t CurlSetSockOpts(void *pData, curl_socket_t curlfd, curlsocktype purpose);
            bool GetFileSize(const Options &options, uint32_t* pSize);
            float DownloadFile(uint32_t index, const Options &options, uint32_t fileSize);
            static size_t CurlReadFunction(void *ptr, size_t size, size_t nmemb, void *userp);
            float UploadFile(const NetworkOptions &options);
            int GetCurrentJitterValue();

            NetworkOptions downloadOptions = { 1,       // numConnections
                                               1,       // timesToUploadOrDownload
                                               -1,      // sndBufSize
                                               -1,      // rcvBufSize
                                               0,       // disableTcpNagle
                                               0,       // uploadSize
                                               "http://natf.com/mb100.zip" };

            NetworkOptions uploadOptions = { 1,         // numConnections
                                             1,         // timesToUploadOrDownload
                                             -1,        // sndBufSize
                                             -1,        // rcvBufSize
                                             0,         // disableTcpNagle
                                             1000,      // uploadSize
                                             "http://natf.com/postfileupload.php" };

            nn::nifm::NetworkConnection* m_pNifmConnection;
            HttpsHelperForCtxImport m_HttpsHelper;
            nn::ssl::Context m_SslContext;
            nn::ssl::CertStoreId m_serverCertStoreId;
            uint8_t *m_pBuf;
            JitterParamType m_jitterType;
            int m_jitterCurrentValue;        // range from 1000 to 10 bytes/sec
        };
    }
}
