﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <Tasks/BaseTask.h>

namespace nnt { namespace abuse {
    struct ThrashThreadArg
    {
        BaseTask* task;
        int index;
        int runtimeMillis;
        bool sleep;
    };

    struct ThrashThreadInfo
    {
        nn::os::ThreadType thread;
        void* stack;
        ThrashThreadArg arg;
    };

    class CpuThrashTask : public BaseTask
    {
    public:
        CpuThrashTask(const String& typeName, const String& instanceName);

        InitStatus     Initialize(const String& params);
        StartStatus    Start();
        RunStatus      Run();
        StopStatus     Stop();
        ShutdownStatus Shutdown();
        const char* GetParamOptions();

    private:
        static void threadFunc(void* threadArg);
        ThrashThreadInfo* m_threadInfo;
        int m_allocatedThreads;
        int m_stackSize;
        int m_numThreads;
        int m_priority;
        int m_minRuntime;
        int m_maxRuntime;
        bool m_useAllCores;
        bool m_sleep;
    };

} } //nn, abuse
