﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <memory>
#include <Platform.h>

namespace nnt
{
    namespace abuse
    {
        template <typename T>
        class PlatformAllocator
        {
        public:
            typedef T value_type;
            typedef T* pointer;
            typedef T& reference;
            typedef const T* const_pointer;
            typedef const T& const_reference;
            typedef size_t size_type;
            typedef ptrdiff_t difference_type;

            template <typename U>
            struct rebind
            {
                typedef PlatformAllocator<U> other;
            };

            PlatformAllocator() {};
            PlatformAllocator(const PlatformAllocator& allocator) {};

            template <typename U>
            PlatformAllocator(const PlatformAllocator<U>& allocator) {};

            ~PlatformAllocator() {};

            pointer address(reference x) const
            {
                return &x;
            }

            const_pointer address(const_reference x) const
            {
                return &x;
            }

            pointer allocate(size_type n, std::allocator<void>::const_pointer hint=0)
            {
                (void)hint;
                return (T*)Platform::Allocate(n * sizeof(value_type));
            }

            void deallocate(pointer p, size_type n)
            {
                (void)n;
                Platform::Free(p);
            }

            size_type max_size() const
            {
                return std::numeric_limits<size_type>::max() / sizeof(value_type);
            }

            void construct (pointer p, const_reference val)
            {
                ::new ((void*)p) value_type(val);
            }

            void destroy(pointer ptr)
            {
                (void)ptr;
                ptr->~value_type();
            }
        };
    }
}
