/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

    .section ".rtld.init", "ax";
    .align  2;
    .global  _start;
    .type   _start, @function;

_start:
    mov     x29, xzr

    // In case of exception, the thread switches to stack=somewhere in the TLR, x0=cause, PC=_start. We need to tell the kernel that we do not handle it to trigger the abort handler
    cmp     x0, #0
    b.eq    NoException;

    ldr     x0, =0x27c // TODO: NotHandled
    bl      _ZN2nn3svc7aarch644lp6419ReturnFromExceptionENS_6ResultE
0:  b       0b

NoException:
    // clear bss
    bl      2f
1:  .word   __bss_start - 1b
2:  ldr     w0, [x30]
    sxtw    x0, w0
    add     x0, x0, x30

    bl      2f
1:  .word   __bss_end - 1b
2:  ldr     w1, [x30]
    sxtw    x1, w1
    add     x1, x1, x30
    sub     x1, x1, x0

    bl      nntSvcFwkLdrClearBss

    // get load base address
    bl      2f
1:  .word   _start - 1b
2:  ldr     w0, [x30]
    sxtw    x0, w0
    add     x0, x0, x30  // r0 <- load base address

    // From rtld.aarch64.lp64.S
    // get .dynamic address
    //  r0 <- load base address
    bl      2f
1:  .word   _DYNAMIC - 1b
2:  ldr     w1, [x30]
    sxtw    x1, w1
    add     x1, x1, x30  //  r1 <- .dynamic address


    // r0 <- load base address
    // r1 <- .dynamic address
    bl      nntSvcFwkLdrRelocate

    bl       nntSvcFwkLdrCallConstructors
    bl       nnMain
  
    b       nntSvcFwkLdrExit