﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Cpu.h>
#include <nn/TargetConfigs/build_Fpu.h>
#include <nn/nn_Log.h>
#include <nnt/gtest/gtest.h>
#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Dmnt.h>
#include <nn/svc/svc_Server.h>
#include <nn/svc/svc_Thread.h>
#include <nn/svc/svc_Result.h>

namespace {
const size_t HeapAlign = 0x00200000;

#if defined NN_BUILD_CONFIG_CPU_ARM_V7A
const uintptr_t HeapAreaBegin = 0x40000000;
const uintptr_t HeapAreaEnd   = 0x7FFFFFFF;
const uintptr_t FreeAreaBegin = 0x38000000;
const uintptr_t FreeAreaEnd   = 0x39000000;
const uintptr_t ProcessBegin  = 0x00000000;
const uintptr_t ProcessEnd    = 0x7fffffff;
const uintptr_t CheckVirtualBegin = 0x00000000ul;
const uintptr_t CheckVirtualEnd   = 0x00000000ul;
#elif defined NN_BUILD_CONFIG_CPU_ARM_V8A
#if defined NN_BUILD_CONFIG_ABI_ILP32
const uintptr_t HeapAreaBegin = 0x40000000;
const uintptr_t HeapAreaEnd   = 0xFFFFFFFF;
const uintptr_t FreeAreaBegin = 0x38000000;
const uintptr_t FreeAreaEnd   = 0x39000000;
const uintptr_t ProcessBegin  = 0x00000000;
const uintptr_t ProcessEnd    = 0xffffffff;
const uintptr_t CheckVirtualBegin = 0x00000000ul;
const uintptr_t CheckVirtualEnd   = 0x00000000ul;
#elif defined NN_BUILD_CONFIG_ABI_LP64
const uintptr_t HeapAreaBegin = 0x0180000000ul;
const uintptr_t HeapAreaEnd   = 0x0ffffffffful;
const uintptr_t FreeAreaBegin = 0x38000000;
const uintptr_t FreeAreaEnd   = 0x39000000;
const uintptr_t ProcessBegin  = 0x0000000000ul;
const uintptr_t ProcessEnd    = 0x0ffffffffful;
const uintptr_t CheckVirtualBegin = 0x0000000000ul;
const uintptr_t CheckVirtualEnd   = 0x1000001000ul;
#endif
#endif

#if defined( NN_BUILD_CONFIG_HARDWARE_BDSLIMX6 )
const uint64_t PhysMemoryBegin = 0x10000000ull;
const uint64_t PhysMemoryEnd   = 0x2fffffffull;
const int NumCore = 4;
#elif defined(NN_BUILD_CONFIG_HARDWARE_JUNO)
const uint64_t PhysMemoryBegin = 0x80000000ull;
const uint64_t PhysMemoryEnd   = 0xffffffffull;
#if defined NN_BUILD_CONFIG_CPU_CORTEX_A53
const int NumCore = 4;
#elif defined NN_BUILD_CONFIG_CPU_CORTEX_A57
const int NumCore = 2;
#else
#endif
#elif defined (NN_BUILD_CONFIG_HARDWARE_KZMA9)
const uint64_t PhysMemoryBegin = 0x40000000ull;
const uint64_t PhysMemoryEnd   = 0x5FFFFFFFull;
const int NumCore = 2;
#elif defined(NN_BUILD_CONFIG_HARDWARE_SMMA53)
const uint64_t PhysMemoryBegin = 0x80000000ull;
const uint64_t PhysMemoryEnd   = 0xFFFFFFFFull;
const int NumCore = 2;
#elif defined(NN_BUILD_CONFIG_HARDWARE_MTBVP)
const uint64_t PhysMemoryBegin = 0x00000000ull;
const uint64_t PhysMemoryEnd   = 0x7fffffffull;
const int NumCore = 4;
#elif defined(NN_BUILD_CONFIG_HARDWARE_SECOMITX)
const uint64_t PhysMemoryBegin = 0xC0000000ull;
const uint64_t PhysMemoryEnd   = 0xDFFFFFFFull;
const int NumCore = 1;
#elif defined (NN_BUILD_CONFIG_HARDWARE_JETSONTK1)
const uint64_t PhysMemoryBegin = 0xA0000000ull;
const uint64_t PhysMemoryEnd   = 0xDFFFFFFFull;
const int NumCore = 4;
#elif defined (NN_BUILD_CONFIG_HARDWARE_JETSONTK2) \
    || defined (NN_BUILD_CONFIG_HARDWARE_NX)
const uint64_t PhysMemoryBegin = 0x80000000ull;
const uint64_t PhysMemoryEnd   = 0xBFFFFFFFull;
const int NumCore = 1;
#endif
}


extern int32_t g_ProcessIdealCore;

#define TEST_RO(addr) do \
{ \
    int32_t tmp; \
    nn::Result result = nn::svc::GetThreadList(&tmp, reinterpret_cast<nn::Bit64*>(addr), 1, nn::svc::Handle(0)); \
    ASSERT_TRUE(result.IsFailure()); \
    tmp = *reinterpret_cast<volatile uint8_t*>(addr); \
} while (false)

#define TEST_RW(addr) do \
{ \
    int32_t tmp; \
    *reinterpret_cast<volatile uint8_t*>(addr) = tmp; \
    tmp = *reinterpret_cast<volatile uint8_t*>(addr); \
} while (false)

#define TEST_NA(addr) do \
{ \
    int32_t tmp; \
    nn::Result result; \
    result = nn::svc::WaitSynchronization(&tmp, reinterpret_cast<nn::svc::Handle*>(addr), 1, 0); \
    ASSERT_TRUE(result.IsFailure() && !(result <= nn::svc::ResultTimeout())); \
} while (false)

class AutoThreadExit
{
public:
    ~AutoThreadExit()
    {
        nn::svc::ExitThread();
    }
};

