﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_TestSvc.h"
#include <nn/svc/svc_Thread.h>
#include <nnt/teamcity/testTeamcity_Logger.h>

int32_t g_ProcessIdealCore;
extern "C" void nnMain()
{
    int   argc    = 0;
    char* argv[1] = { NULL };
    ::testing::InitGoogleTest(&argc, argv);

    // TeamCity の表示を適切にするため、イベントリスナの登録を一旦すべて解除し、
    // ServiceMessageLogger -> デフォルトのイベントリスナ の順で登録し直す。
    ::testing::TestEventListeners& listeners = ::testing::UnitTest::GetInstance()->listeners();
    ::testing::TestEventListener* defaultResultPrinter = listeners.Release(listeners.default_result_printer());
    listeners.Append(new nnt::teamcity::ServiceMessageLogger());
    listeners.Append(defaultResultPrinter);

    {
        nn::Bit64 mask;
        nn::Result result = nn::svc::GetThreadCoreMask(&g_ProcessIdealCore, &mask, static_cast<nn::svc::Handle>(nn::svc::PSEUDO_HANDLE_CURRENT_THREAD));
        if (result.IsFailure())
        {
            return;
        }
        if (nn::svc::GetCurrentProcessorNumber() != g_ProcessIdealCore)
        {
            return;
        }
    }

    RUN_ALL_TESTS();
}
