﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "sdmmc_Result.h"
#include "sdmmc_IHostController.h"

namespace nn { namespace sdmmc1 {
namespace detail {

class IDevice
{
public:
    enum DeviceType
    {
        DeviceType_Mmc,
        DeviceType_SdCard
    };

    virtual void Initialize(IHostController* pHostController) NN_NOEXCEPT = 0;
    virtual Result Activate() NN_NOEXCEPT = 0;
    virtual Result ReadWrite(uint32_t sectorIndex, uint32_t numSectors, void* pBuffer, size_t bufferSize, bool isRead) const NN_NOEXCEPT = 0;
};

} // namespace detail {
}} // namespace nn { namespace sdmmc1 {
