﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "sdmmc_IDevice.h"
#include "sdmmc_IHostController.h"

namespace nn { namespace sdmmc1 {
namespace detail {

// Device Status の CURRENT_STATE 定義
enum DeviceState
{
    DeviceState_Idle = 0,
    DeviceState_Ready = 1,
    DeviceState_Ident = 2,
    DeviceState_Stby = 3,
    DeviceState_Tran = 4,
    DeviceState_Data = 5,
    DeviceState_Rcv = 6,
    DeviceState_Prg = 7,
    DeviceState_Dis = 8,
    DeviceState_Unknown = 0x10  // CURRENT_STATE は 4bit のため値に該当するものはない
};

class BaseDevice : public IDevice
{
private:
    IHostController* m_pHostController;
    DeviceType m_DeiceType;
    uint32_t m_DeviceClockFrequencyKHz;
    bool m_IsHighCapacity;
    uint16_t m_Rca;

protected:
    void Initialize(IHostController* pHostController, DeviceType deiceType) NN_NOEXCEPT
    {
        m_pHostController = pHostController;
        m_DeiceType = deiceType;
        m_Rca = 0;
    }

    IHostController* GetHostController() const NN_NOEXCEPT
    {
        return m_pHostController;
    }
    void SetRca(uint16_t rca) NN_NOEXCEPT
    {
        m_Rca = rca;
    }
    void SetBusIdentificationMode(IHostController::BusPower* pOutBusPower) NN_NOEXCEPT;
    void ChangeDeviceClockMode(IHostController::DeviceClockMode deviceClockMode) NN_NOEXCEPT;
    void SetHighCapacity(bool isHighCapacity) NN_NOEXCEPT
    {
        m_IsHighCapacity = isHighCapacity;
    }
    Result IssueCommandAndCheckR1(uint32_t commandIndex, uint32_t commandArgument, bool isBusy, DeviceState expectedState) const NN_NOEXCEPT;
    Result IssueCommandGoIdleState() const NN_NOEXCEPT;
    Result IssueCommandAllSendCid(uint32_t* pOutCid, size_t cidSize) const NN_NOEXCEPT;
    Result IssueCommandSelectCard(uint16_t rca) const NN_NOEXCEPT;
    Result IssueCommandSendCsd(uint32_t* pOutCsd, size_t csdSize, uint16_t rca) const NN_NOEXCEPT;
    Result IssueCommandSendStatus(uint16_t rca) const NN_NOEXCEPT;
    Result IssueCommandMultipleBlock(uint32_t* pOutTransferredNumBlocks, uint32_t sectorIndex, uint32_t numSectors, void* pBuffer, bool isRead, bool isHighCapacity) const NN_NOEXCEPT;

public:
    virtual Result ReadWrite(uint32_t sectorIndex, uint32_t numSectors, void* pBuffer, size_t bufferSize, bool isRead) const NN_NOEXCEPT NN_OVERRIDE;
};

} // namespace detail {
}} // namespace nn { namespace sdmmc1 {
