﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Cpu.h>
#include <nn/TargetConfigs/build_Fpu.h>
#include <nn/TargetConfigs/build_Base.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#ifndef NO_GOOGLE_TEST
#include <nnt/gtest/gtest.h>
#endif
#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Dmnt.h>
#include <nn/svc/svc_Server.h>
#include <nn/svc/svc_Thread.h>
#include <nn/svc/svc_Result.h>

#define NN_TEST_CONFIG_SVC
#include "../../../../Programs/Chris/Sources/Kernel/kern_Platform.h"
#include "../../../../Programs/Chris/Sources/Kernel/kern_MemoryMapSelect.h"
#include <nn/svc/svc_MemoryMapSelect.h>

namespace {
const int32_t TestRepeatNum = 2;
const int32_t TestHighestThreadPriority = nn::svc::HighestThreadPriority + 32;
const int32_t TestLowestThreadPriority = nn::svc::LowestThreadPriority;
const int32_t TestMemoryControlBlockNum = 3;
const size_t HeapAlign = 0x00200000;
const size_t DefaultStackSize = 0x8000;
const size_t DefaultUserBufferSize = 0x2000;
inline int32_t GetTimeSlicePriority(int32_t coreNo)
{
    NN_UNUSED(coreNo);
#if defined(NN_BUILD_CONFIG_HARDWARE_NX)
    if (coreNo == 3)
    {
        return 63;
    }
    else
#endif
    {
        return 59;
    }
}
const int32_t NumMaxHandle = 1023;

#if defined NN_BUILD_CONFIG_CPU_ARM_V7A
const uintptr_t HeapAreaBegin = 0x40000000;
const uintptr_t HeapAreaEnd   = 0x7FFFFFFF;
const uintptr_t ProcessBegin  = 0x00000000;
const uintptr_t ProcessEnd    = 0x7fffffff;
const uintptr_t SmallRegionBegin = NN_SVC_ADDR_MEMORY_REGION_SMALL32_BEGIN;
const uintptr_t SmallRegionEnd   = NN_SVC_ADDR_MEMORY_REGION_SMALL32_END - 1;
const uintptr_t LargeRegionBegin = NN_SVC_ADDR_MEMORY_REGION_LARGE32_BEGIN;
const uintptr_t LargeRegionEnd   = NN_SVC_ADDR_MEMORY_REGION_LARGE32_END - 1;
const uintptr_t CheckVirtualBegin = 0x00000000ul;
const uintptr_t CheckVirtualEnd   = 0x00000000ul;
const uint64_t AddressSpaceSize32 = 0x100000000ul;
const uint64_t AddressSpaceSize64 = 0x00000000ul; // サポートしていない
#elif defined NN_BUILD_CONFIG_CPU_ARM_V8A
#if defined NN_BUILD_CONFIG_ABI_ILP32
const uintptr_t HeapAreaBegin = 0x40000000;
const uintptr_t HeapAreaEnd   = 0xFFFFFFFF;
const uintptr_t ProcessBegin  = 0x00000000;
const uintptr_t ProcessEnd    = 0xffffffff;
const uintptr_t SmallRegionBegin = NN_SVC_ADDR_MEMORY_REGION_SMALL32_BEGIN;
const uintptr_t SmallRegionEnd   = NN_SVC_ADDR_MEMORY_REGION_SMALL32_END - 1;
const uintptr_t LargeRegionBegin = NN_SVC_ADDR_MEMORY_REGION_LARGE32_BEGIN;
const uintptr_t LargeRegionEnd   = NN_SVC_ADDR_MEMORY_REGION_LARGE32_END - 1;
const uintptr_t CheckVirtualBegin = 0x00000000ul;
const uintptr_t CheckVirtualEnd   = 0x00000000ul;
#elif defined NN_BUILD_CONFIG_ABI_LP64
const uintptr_t HeapAreaBegin = 0x0080000000ul;
const uintptr_t HeapAreaEnd   = 0x0ffffffffful;
const uintptr_t ProcessBegin  = 0x0000000000ul;
const uintptr_t ProcessEnd    = 0x0ffffffffful;
const uintptr_t SmallRegionBegin = NN_SVC_ADDR_MEMORY_REGION_SMALL64_BEGIN;
const uintptr_t SmallRegionEnd   = NN_SVC_ADDR_MEMORY_REGION_SMALL64_END - 1;
const uintptr_t LargeRegionBegin = NN_SVC_ADDR_MEMORY_REGION_LARGE64_BEGIN;
const uintptr_t LargeRegionEnd   = NN_SVC_ADDR_MEMORY_REGION_LARGE64_END - 1;
const uintptr_t CheckVirtualBegin = 0x0000000000ul;
const uintptr_t CheckVirtualEnd   = 0x1000001000ul;
#endif
const uint64_t AddressSpaceSize32 = 0x100000000ul;
const uint64_t AddressSpaceSize64 = 0x1000000000ul;
#endif

#if defined( NN_BUILD_CONFIG_HARDWARE_BDSLIMX6 )
const int NumCore = 4;
#elif defined(NN_BUILD_CONFIG_HARDWARE_JUNO)
#if defined NN_BUILD_CONFIG_CPU_CORTEX_A53
const int NumCore = 4;
#elif defined NN_BUILD_CONFIG_CPU_CORTEX_A57
const int NumCore = 2;
#else
#endif
#elif defined (NN_BUILD_CONFIG_HARDWARE_KZMA9)
const int NumCore = 2;
#elif defined(NN_BUILD_CONFIG_HARDWARE_SMMA53)
const int NumCore = 2;
#elif defined(NN_BUILD_CONFIG_HARDWARE_MTBVP)
const int NumCore = 4;
#elif defined(NN_BUILD_CONFIG_HARDWARE_SECOMITX)
const int NumCore = 1;
#elif defined (NN_BUILD_CONFIG_HARDWARE_JETSONTK1)
const int NumCore = 4;
#elif defined (NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || defined (NN_BUILD_CONFIG_HARDWARE_NX)
const int NumCore = 4;
#endif

const uint64_t PhysMemoryBegin = NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY;
const uint64_t PhysMemoryEnd = NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY_END;
const uint64_t PhysMemorySize = NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY_SIZE;

}


extern int32_t g_ProcessIdealCore;
extern uintptr_t g_HeapAreaBegin;
extern uintptr_t g_HeapAreaEnd;
extern uintptr_t g_ReservedAreaBegin;
extern uintptr_t g_ReservedAreaEnd;
extern uintptr_t g_FreeAreaBegin;
extern uintptr_t g_FreeAreaEnd;

#define TEST_RO(addr) do \
{ \
    int32_t tmp; \
    nn::Result result = nn::svc::GetThreadList(&tmp, reinterpret_cast<nn::Bit64*>(addr), 1, nn::svc::Handle(0)); \
    ASSERT_TRUE(result.IsFailure()); \
    tmp = *reinterpret_cast<volatile uint8_t*>(addr); \
} while (false)

#define TEST_RW(addr) do \
{ \
    int32_t tmp = 0; \
    *reinterpret_cast<volatile uint8_t*>(addr) = tmp; \
    tmp = *reinterpret_cast<volatile uint8_t*>(addr); \
} while (false)

#define TEST_NA(addr) do \
{ \
    int32_t tmp; \
    nn::Result result; \
    result = nn::svc::WaitSynchronization(&tmp, reinterpret_cast<nn::svc::Handle*>(addr), 1, 0); \
    ASSERT_TRUE(result.IsFailure() && !(result <= nn::svc::ResultTimeout())); \
} while (false)

class AutoThreadExit
{
public:
    ~AutoThreadExit()
    {
        nn::svc::ExitThread();
    }
};

