﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace {

const char* PortName = "Terminate";
const size_t SharedSize = 0x1000;

enum TestTag
{
    TestTag_Init,
    TestTag_WriteEvent,
    TestTag_ReadEvent,
    TestTag_SendSyncLightPort,
    TestTag_SendSyncLightSession,

    TestTag_Ipc_Server_Send,

    TestTag_Ipc_Client_Send,

    TestTag_Ipc_Client_Receive,
    TestTag_Ipc_Server_Receive,
    TestTag_Ipc_Server_Reply,
    TestTag_Ipc_Client_Reply,
    TestTag_Ipc_Client_MultiSend,
    TestTag_Ipc_Client_MultiReceive,
    TestTag_Ipc_Server_MultiSend,
    TestTag_Ipc_Server_MultiReceive,
    TestTag_Ipc_Server_MultiSendMoveSession,
    TestTag_Ipc_Server_MultiReceiveMoveSession,
    TestTag_Ipc_Process_Sending,
    TestTag_Ipc_Process_Receiving,
    TestTag_Thread,
    TestTag_Interrupt,
    TestTag_Shared,
    TestTag_Sleep,
    TestTag_Transfer,
    TestTag_DeviceAddress,
};

enum TestIpcTag
{
    TestIpcTag_SendSyncReceive,
    TestIpcTag_SendSyncReceiveWith,
    TestIpcTag_SendSyncWithReceive,
    TestIpcTag_SendSyncWithReceiveWith,
    TestIpcTag_SendAsyncWithReceive,
    TestIpcTag_SendAsyncWithReceiveWith,
};

enum TestPort
{
    TestPort_NamedPort,
    TestPort_Port,
    TestPort_Session,
};

const TestIpcTag IpcTags[] = {
    TestIpcTag_SendSyncReceive,
    TestIpcTag_SendSyncReceiveWith,
    TestIpcTag_SendSyncWithReceive,
    TestIpcTag_SendSyncWithReceiveWith,
    TestIpcTag_SendAsyncWithReceive,
    TestIpcTag_SendAsyncWithReceiveWith,
};

const TestPort PortTags[] = {
    TestPort_NamedPort,
    TestPort_Port,
    TestPort_Session,
};

enum SendMethod
{
    SendMethod_UseTls,
    SendMethod_UseBuffer,
    SendMethod_UseAsync
};

const SendMethod SendMethodArray[] = {
    SendMethod_UseTls,
    SendMethod_UseBuffer,
    SendMethod_UseAsync
};

enum ReceiveMethod
{
    ReceiveMethod_UseTls,
    ReceiveMethod_UseBuffer
};

const ReceiveMethod ReceiveMethodArray[] = {
    ReceiveMethod_UseTls,
    ReceiveMethod_UseBuffer
};

enum IpcDataType
{
    IpcDataType_All,
    IpcDataType_ProcessId,
    IpcDataType_CopyHandle,
    IpcDataType_MoveHandle,
    IpcDataType_Pointer_IpcBuffer,
    IpcDataType_Pointer_OneBuffer,
    IpcDataType_Pointer_MultiBuffer,
    IpcDataType_Map_Send,
    IpcDataType_Map_Receive,
    IpcDataType_Map_Exchange,
    IpcDataType_Raw
};

const IpcDataType IpcDataTypeArray[] = {
    IpcDataType_ProcessId,
    IpcDataType_CopyHandle,
    IpcDataType_MoveHandle,
    IpcDataType_Pointer_IpcBuffer,
    IpcDataType_Pointer_OneBuffer,
    IpcDataType_Pointer_MultiBuffer,
    IpcDataType_Map_Send,
    IpcDataType_Map_Receive,
    IpcDataType_Map_Exchange,
    IpcDataType_Raw,
    IpcDataType_All
};

enum SessionType
{
    SessionType_Port,
    SessionType_NamedPort,
    SessionType_Session
};

const SessionType SessionTypeArray[] = {
    SessionType_Port,
    SessionType_NamedPort,
    SessionType_Session
};


struct TestInfo
{
    SendMethod sendMethod;
    ReceiveMethod receiveMethod;
    IpcDataType dataType;
    SessionType sessionType;
};

struct CheckInfo
{
    nn::svc::Handle processHandle;
    nn::svc::Handle copyHandle;
    nn::svc::Handle moveHandle;
    uintptr_t mapSendAddr;
    uintptr_t mapReceiveAddr;
    uintptr_t mapExchangeAddr;
    size_t mapSendSize;
    size_t mapReceiveSize;
    size_t mapExchangeSize;
};

const char* PointData1 = "PointData1";
const char* PointData2 = "PointData2";
const char* RawData1 = "12345";

const int32_t SendPointDataNum = 2;
const char* SendPointData[2] = { PointData1, PointData2};
const size_t SendPointDataSize[2] = { sizeof(PointData1), sizeof(PointData2)};
/*
const int32_t ReplyPointDataNum = 2;
const char* ReplyPointData[2] = { PointData2, PointData1};
const size_t ReplyPointDataSize[2] = { sizeof(PointData2), sizeof(PointData1)};
*/
const uint8_t SendMapSendData = 0x1;
const uint8_t SendMapRecvData = 0x2;
const uint8_t SendMapExchData = 0x3;
/*
const uint8_t ReplyMapSendData = 0xc;
const uint8_t ReplyMapRecvData = 0xd;
const uint8_t ReplyMapExchData = 0xe;
*/
const size_t MapSendSize = 0x1001;
const size_t MapRecvSize = 0xfff;
const size_t MapExchSize = 0x1000;
const size_t MapDefaultSize = 0x1000;
const char* SendRawData = RawData1;
const size_t SendRawDataSize = sizeof(RawData1);
/*
const char* ReplyRawData = RawData2;
const size_t ReplyRawDataSize = sizeof(RawData2);
*/

}
